/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.wizard.pages;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.paste.PasteSeparator;
import org.eclipse.papyrus.infra.nattable.paste.TextDelimiter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImportCSVConfigurationPage
extends WizardPage {
    private PasteSeparator separator;
    private TextDelimiter textDelimiter;
    private char[] textChar = null;

    public ImportCSVConfigurationPage(String pageName, String title, ImageDescriptor titleImage, PasteSeparator defaultSeparator, TextDelimiter defaultDelimiter) {
        super(pageName, title, titleImage);
        this.setDescription(Messages.ImportFilePage_SelectTheFileToImport);
        this.separator = defaultSeparator;
        this.textDelimiter = defaultDelimiter;
    }

    public void createControl(Composite parent1) {
        Composite pageComposite = new Composite(parent1, 0);
        this.setControl((Control)pageComposite);
        pageComposite.setLayout((Layout)new GridLayout(2, true));
        Group separatorGroup = new Group(pageComposite, 0);
        separatorGroup.setText(Messages.ImportCSVConfigurationPage_Separators);
        separatorGroup.setLayout((Layout)new GridLayout(2, false));
        PasteSeparator[] pasteSeparatorArray = PasteSeparator.values();
        int n = pasteSeparatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            final PasteSeparator current = pasteSeparatorArray[n2];
            final Button button = new Button((Composite)separatorGroup, 16);
            button.setText(current.getName());
            button.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (button.isEnabled()) {
                        ImportCSVConfigurationPage.this.separator = current;
                    }
                    ImportCSVConfigurationPage.this.setPageComplete(ImportCSVConfigurationPage.this.validate());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            button.setSelection(current == this.separator);
            GridData data = new GridData();
            if (current == PasteSeparator.OTHER) {
                final Text text = new Text((Composite)separatorGroup, 2048);
                text.addKeyListener(new KeyListener(){

                    public void keyReleased(KeyEvent e) {
                        ImportCSVConfigurationPage.this.textChar = text.getTextChars();
                        ImportCSVConfigurationPage.this.setPageComplete(ImportCSVConfigurationPage.this.validate());
                    }

                    public void keyPressed(KeyEvent e) {
                    }
                });
                button.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        text.setEnabled(button.getSelection());
                        ImportCSVConfigurationPage.this.setPageComplete(ImportCSVConfigurationPage.this.validate());
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                text.setEnabled(this.separator == PasteSeparator.OTHER);
            } else {
                data.horizontalSpan = 2;
            }
            button.setLayoutData((Object)data);
            ++n2;
        }
        Composite textDelimiterComp = new Composite(pageComposite, 0);
        textDelimiterComp.setLayout((Layout)new GridLayout(2, false));
        textDelimiterComp.setLayoutData((Object)new GridData());
        Label label2 = new Label(textDelimiterComp, 0);
        label2.setText(Messages.ImportCSVConfigurationPage_SelectTheTextDelimiter);
        final Combo combo = new Combo(textDelimiterComp, 12);
        int i = 0;
        while (i < TextDelimiter.values().length) {
            TextDelimiter current = TextDelimiter.values()[i];
            combo.add(String.valueOf(current.getDelimiter()), i);
            if (this.textDelimiter == current) {
                combo.select(i);
            }
            ++i;
        }
        combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImportCSVConfigurationPage.this.textDelimiter = TextDelimiter.values()[combo.getSelectionIndex()];
                ImportCSVConfigurationPage.this.setPageComplete(ImportCSVConfigurationPage.this.validate());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setPageComplete(this.validate());
    }

    private boolean validate() {
        if (this.separator == PasteSeparator.OTHER) {
            if (this.textChar == null || this.textChar.length == 0) {
                this.setErrorMessage(Messages.ImportCSVConfigurationPage_TheCellSeparatorIsNotDefined);
                return false;
            }
            if (this.textChar.length > 1) {
                this.setErrorMessage(Messages.ImportCSVConfigurationPage_TheCellSeparatorMustBeExcatlyOneChar);
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    public char getSeparator() {
        if (this.separator == PasteSeparator.OTHER) {
            return this.textChar[0];
        }
        return this.separator.getSeparator();
    }

    public char getTextDelimiter() {
        return this.textDelimiter.getDelimiter();
    }
}

