/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.internationalization.ui.dialogs;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferencesUtils;
import org.eclipse.papyrus.infra.internationalization.ui.messages.Messages;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class InternationalizationDialog
extends TrayDialog {
    private URI resourceURI;
    protected TableViewer tableViewer;
    protected Button useInternationalizationButton;
    protected boolean useInternationalizationValue;
    protected Locale localeValue;
    private boolean displayUse;

    public InternationalizationDialog(Shell parentShell, URI resourceURI, boolean displayUse) {
        super(parentShell);
        this.setResourceURI(resourceURI);
        this.displayUse = displayUse;
    }

    public void setResourceURI(URI resourceURI) {
        this.resourceURI = resourceURI;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 300;
        data.heightHint = 300;
        composite.setLayoutData((Object)data);
        this.getShell().setText("Configure internationalization");
        this.getShell().setImage(Activator.getDefault().getImage("/icons/papyrus.png"));
        if (this.displayUse()) {
            this.createUseInternationalization(composite);
        }
        this.createLanguage(composite);
        this.initializeValues();
        return composite;
    }

    protected boolean displayUse() {
        return this.displayUse;
    }

    protected void createUseInternationalization(Composite parent) {
        this.useInternationalizationButton = new Button(parent, 32);
        this.useInternationalizationButton.setText(Messages.InternationalizationDialog_UseInternationalizationLabel);
    }

    protected void createLanguage(Composite parent) {
        this.tableViewer = new TableViewer(parent, 2048);
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = 200;
        data.minimumWidth = 100;
        this.tableViewer.getTable().setLayoutData((Object)data);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        List<Locale> availableLocales = Arrays.asList(Locale.getAvailableLocales());
        availableLocales.sort(new Comparator<Locale>(){

            @Override
            public int compare(Locale arg0, Locale arg1) {
                return arg0.toString().compareTo(arg1.toString());
            }
        });
        this.tableViewer.setInput(availableLocales);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                InternationalizationDialog.this.setReturnCode(0);
                InternationalizationDialog.this.close();
            }
        });
    }

    protected void initializeValues() {
        if (this.displayUse()) {
            this.useInternationalizationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InternationalizationDialog.this.useInternationalizationValue = InternationalizationDialog.this.useInternationalizationButton.getSelection();
                }
            });
            boolean useInternationalization = InternationalizationPreferencesUtils.getInternationalizationPreference((URI)this.resourceURI);
            this.useInternationalizationButton.setSelection(useInternationalization);
            this.useInternationalizationValue = useInternationalization;
        }
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Locale localeSelected;
                ISelection selection = event.getSelection();
                InternationalizationDialog.this.localeValue = localeSelected = (Locale)((StructuredSelection)selection).getFirstElement();
            }
        });
        Locale locale = InternationalizationPreferencesUtils.getLocalePreference((URI)this.resourceURI);
        this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)locale));
        this.tableViewer.reveal((Object)locale);
    }

    public boolean getUseInternationalizationValue() {
        return this.useInternationalizationValue;
    }

    public Locale getLocaleValue() {
        return this.localeValue;
    }
}

