/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.figure.node;

import java.util.StringTokenizer;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.PapyrusWrappingLabel;
import org.eclipse.papyrus.uml.diagram.common.figure.layout.PropertiesCompartmentLayoutManager;
import org.eclipse.papyrus.uml.diagram.common.figure.node.AppliedStereotypeCompartmentFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IPapyrusNodeNamedElementFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IPapyrusNodeUMLElementFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.LabelWithScalableIcons;
import org.eclipse.papyrus.uml.diagram.common.figure.node.PapyrusNodeFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.StereotypePropertiesCompartment;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class NodeNamedElementFigure
extends PapyrusNodeFigure
implements IPapyrusNodeNamedElementFigure,
IPapyrusNodeUMLElementFigure {
    protected boolean noBorder = false;
    protected static final String CHEVRON = String.valueOf("\u00ab") + String.valueOf("\u00bb");
    protected PapyrusWrappingLabel taggedLabel;
    private int depth = 0;
    protected Label iconLabel;
    protected PapyrusWrappingLabel nameLabel;
    protected Image nameLabelIcon = null;
    protected PapyrusWrappingLabel qualifiedLabel;
    private RectangleFigure stereotypePropertiesContent;
    protected PapyrusWrappingLabel stereotypePropertiesInBraceContent;
    protected PapyrusWrappingLabel stereotypesLabel;
    protected int namePosition = 16;

    public NodeNamedElementFigure() {
        this(null);
    }

    public void setBorder(Border border) {
        this.noBorder = border == null;
        super.setBorder(border);
    }

    @Override
    protected Border getDefaultBorder(Color borderColor) {
        if (this.noBorder) {
            return null;
        }
        return super.getDefaultBorder(borderColor);
    }

    public void remove(IFigure figure) {
        if (figure instanceof AppliedStereotypeCompartmentFigure) {
            if (this.stereotypePropertiesContent == null) {
                this.createStereotypePropertiesContent();
            }
            this.stereotypePropertiesContent.remove(figure);
        } else {
            super.remove(figure);
        }
    }

    public void add(IFigure figure, Object constraint, int index) {
        if (figure != null) {
            if (figure instanceof AppliedStereotypeCompartmentFigure) {
                if (this.stereotypePropertiesContent == null) {
                    this.createStereotypePropertiesContent();
                }
                this.stereotypePropertiesContent.add(figure);
            } else {
                super.add(figure, constraint, index);
            }
        }
    }

    @Override
    public void setStereotypeDisplay(String stereotypes, Image image) {
        if (!"".equals(stereotypes)) {
            this.setStereotypes(stereotypes);
        } else {
            this.setStereotypes(null);
        }
        this.setAppliedStereotypeIcon(image);
    }

    public NodeNamedElementFigure(String taggedLabelValue) {
        this.createNameLabel();
        this.initTagLabel(taggedLabelValue);
    }

    protected void createNameLabel() {
        this.nameLabel = new PapyrusWrappingLabel();
        this.nameLabel.setOpaque(false);
        this.nameLabel.setAlignment(this.namePosition);
        this.getNameLabelContainer().add((IFigure)this.nameLabel, this.getNameLabelConstraint(), -1);
    }

    public void setNamePosition(int namePosition) {
        this.namePosition = namePosition;
    }

    @Override
    public void restoreNameLabel() {
        this.nameLabel.setOpaque(false);
        this.nameLabel.setAlignment(this.namePosition);
        this.getNameLabelContainer().add((IFigure)this.nameLabel, this.getNameLabelConstraint(), this.getNameLabelPosition());
        if (this.qualifiedLabel != null) {
            this.qualifiedLabel.setOpaque(false);
            this.qualifiedLabel.setAlignment(this.namePosition);
        }
    }

    @Override
    public void removeNameLabel() {
        if (this.getNameLabelContainer().getChildren().contains(this.nameLabel)) {
            this.getNameLabelContainer().remove((IFigure)this.nameLabel);
        }
    }

    @Override
    public void restoreStereotypeLabel() {
        if (this.stereotypesLabel != null) {
            this.stereotypesLabel.setOpaque(false);
            this.stereotypesLabel.setAlignment(this.namePosition);
            this.getStereotypeLabelContainer().add((IFigure)this.stereotypesLabel, this.getStereotypeLabelConstraint(), this.getStereotypeLabelPosition());
        }
        if (this.stereotypePropertiesInBraceContent != null) {
            this.stereotypePropertiesInBraceContent.setOpaque(false);
            this.stereotypePropertiesInBraceContent.setAlignment(this.namePosition);
        }
    }

    @Override
    public void removeStereotypeLabel() {
        if (this.stereotypesLabel != null && this.getStereotypeLabelContainer().getChildren().contains(this.stereotypesLabel)) {
            this.getStereotypeLabelContainer().remove((IFigure)this.stereotypesLabel);
        }
    }

    @Override
    public void restoreTaggedLabel() {
        if (this.taggedLabel != null) {
            this.taggedLabel.setOpaque(false);
            this.taggedLabel.setAlignment(this.namePosition);
            this.getTagLabelContainer().add((IFigure)this.taggedLabel, this.getTagLabelConstraint(), 0);
        }
    }

    @Override
    public void removeTaggedLabel() {
        if (this.taggedLabel != null && this.getTagLabelContainer().getChildren().contains(this.taggedLabel)) {
            this.getTagLabelContainer().remove((IFigure)this.taggedLabel);
        }
    }

    protected Object getNameLabelConstraint() {
        return this.getDefaultLabelsConstraint();
    }

    protected Object getIconLabelConstraint() {
        return this.getDefaultLabelsConstraint();
    }

    protected Object getQualifiedNameLabelConstraint() {
        return this.getDefaultLabelsConstraint();
    }

    protected Object getStereotypeLabelConstraint() {
        return this.getDefaultLabelsConstraint();
    }

    protected Object getStereotypePropertiesInBraceLabelConstraint() {
        return this.getDefaultLabelsConstraint();
    }

    protected Object getStereotypePropertiesCompartmentConstraint() {
        return this.getDefaultLabelsConstraint();
    }

    protected Object getTagLabelConstraint() {
        return this.getDefaultLabelsConstraint();
    }

    protected Object getDefaultLabelsConstraint() {
        return null;
    }

    protected IFigure getNameLabelContainer() {
        return this.getDefaultLabelsContainer();
    }

    protected IFigure getIconLabelContainer() {
        return this.getDefaultLabelsContainer();
    }

    protected IFigure getQualifiedNameLabelContainer() {
        return this.getDefaultLabelsContainer();
    }

    protected IFigure getStereotypeLabelContainer() {
        return this.getDefaultLabelsContainer();
    }

    protected IFigure getStereotypePropertiesInBraceLabelContainer() {
        return this.getDefaultLabelsContainer();
    }

    protected IFigure getStereotypePropertiesCompartmentContainer() {
        return this.getDefaultLabelsContainer();
    }

    protected IFigure getTagLabelContainer() {
        return this.getDefaultLabelsContainer();
    }

    protected IFigure getDefaultLabelsContainer() {
        return this;
    }

    protected void createIconLabel() {
        this.iconLabel = new LabelWithScalableIcons();
        this.getIconLabelContainer().add((IFigure)this.iconLabel, this.getIconLabelConstraint(), this.getIconLabelPosition());
        this.iconLabel.setLabelAlignment(1);
    }

    protected void createIconLabel(int position) {
        this.iconLabel = new LabelWithScalableIcons();
        this.getIconLabelContainer().add((IFigure)this.iconLabel, this.getIconLabelConstraint(), this.getIconLabelPosition());
        this.iconLabel.setLabelAlignment(position);
    }

    protected void createQualifiedNameLabel() {
        this.qualifiedLabel = new PapyrusWrappingLabel();
        this.qualifiedLabel.setOpaque(false);
        this.qualifiedLabel.setFont(this.getNameLabel().getFont());
        this.qualifiedLabel.setForegroundColor(this.getNameLabel().getForegroundColor());
        this.getQualifiedNameLabelContainer().add((IFigure)this.qualifiedLabel, this.getQualifiedNameLabelConstraint(), this.getQualifiedNameLabelPosition());
    }

    protected void createStereotypeLabel() {
        this.stereotypesLabel = new PapyrusWrappingLabel();
        this.stereotypesLabel.setOpaque(false);
        this.stereotypesLabel.setAlignment(this.namePosition);
        this.stereotypesLabel.setFont(this.getNameLabel().getFont());
        this.stereotypesLabel.setForegroundColor(this.getNameLabel().getForegroundColor());
        this.getStereotypeLabelContainer().add((IFigure)this.stereotypesLabel, this.getStereotypeLabelConstraint(), this.getStereotypeLabelPosition());
    }

    protected void createStereotypePropertiesInBraceLabel() {
        this.stereotypePropertiesInBraceContent = new PapyrusWrappingLabel();
        this.stereotypePropertiesInBraceContent.setOpaque(false);
        this.getStereotypePropertiesInBraceLabelContainer().add((IFigure)this.stereotypePropertiesInBraceContent, this.getStereotypePropertiesInBraceLabelConstraint(), this.getStereotypePropertiesLabelPosition());
    }

    protected void createStereotypePropertiesContent() {
        this.stereotypePropertiesContent = new StereotypePropertiesCompartment();
        this.stereotypePropertiesContent.setFill(false);
        this.stereotypePropertiesContent.setLineWidth(0);
        this.stereotypePropertiesContent.setBorder(null);
        this.stereotypePropertiesContent.setLayoutManager(this.getPropertiesCompartmentLayout());
        this.getStereotypePropertiesCompartmentContainer().add((IFigure)this.stereotypePropertiesContent, this.getStereotypePropertiesCompartmentConstraint(), this.getStereotypePropertiesCompartmentPosition());
    }

    protected LayoutManager getPropertiesCompartmentLayout() {
        return new PropertiesCompartmentLayoutManager();
    }

    private void fillStereotypePropertiesInCompartment(String stereotypeProperties) {
        this.stereotypePropertiesContent.getChildren().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(stereotypeProperties, ";");
        while (stringTokenizer.hasMoreElements()) {
            String tokenStereotype = stringTokenizer.nextToken();
            tokenStereotype = tokenStereotype.replace("#", "\n  ");
            tokenStereotype = tokenStereotype.replace("|", "\n  ");
            Label label = new Label(tokenStereotype);
            label.setLabelAlignment(1);
            label.setBorder(null);
            this.stereotypePropertiesContent.add((IFigure)label);
        }
    }

    @Override
    public WrappingLabel getTaggedLabel() {
        return this.taggedLabel;
    }

    public int getDepth() {
        return this.depth;
    }

    public Label getIconLabel() {
        return this.iconLabel;
    }

    protected void initTagLabel(String value) {
        if (value != null && value.length() > 0) {
            this.taggedLabel = new PapyrusWrappingLabel();
            String textToDisplay = new StringBuffer(CHEVRON).insert(1, value).toString();
            this.taggedLabel.setText(textToDisplay);
            this.taggedLabel.setOpaque(false);
            this.taggedLabel.setForegroundColor(this.getNameLabel().getForegroundColor());
            this.taggedLabel.setFont(this.getNameLabel().getFont());
            this.getTagLabelContainer().add((IFigure)this.taggedLabel, this.getTagLabelConstraint(), 0);
        }
    }

    public Dimension getMinimumDimension() {
        int width = 0;
        int height = 0;
        int temporysize = 0;
        if (this.getNameLabelContainer().getChildren().contains(this.getNameLabel())) {
            width = this.getNameLabel().getTextBounds().width + 10;
            height = this.getNameLabel().getTextBounds().height + 10;
        }
        if (this.getStereotypesLabel() != null) {
            temporysize = this.getStereotypesLabel().getTextBounds().width + 10;
            height += this.getStereotypesLabel().getTextBounds().height;
            if (width < temporysize) {
                width = temporysize;
            }
        }
        if (this.getQualifiedNameLabel() != null) {
            temporysize = this.getQualifiedNameLabel().getTextBounds().width + 10;
            height += this.getQualifiedNameLabel().getTextBounds().height;
            if (width < temporysize) {
                width = temporysize;
            }
        }
        return new Dimension(width, height);
    }

    protected int getNameHeight() {
        int nameHeight = this.getNameLabel().getPreferredSize().height;
        if (this.getIconLabel() != null && this.getIconLabelContainer().equals(this.getNameLabelContainer())) {
            nameHeight += this.getIconLabel().getPreferredSize().height;
        }
        if (this.getStereotypesLabel() != null && this.getStereotypeLabelContainer().equals(this.getNameLabelContainer())) {
            nameHeight += this.getStereotypesLabel().getPreferredSize().height;
        }
        if (this.getQualifiedNameLabel() != null && this.getQualifiedNameLabelContainer().equals(this.getNameLabelContainer())) {
            nameHeight += this.getQualifiedNameLabel().getPreferredSize().height;
        }
        return nameHeight += 5;
    }

    @Override
    public WrappingLabel getNameLabel() {
        return this.nameLabel;
    }

    public Image getNameLabelIcon() {
        return this.nameLabelIcon;
    }

    /*
     * Unable to fully structure code
     */
    public String getQualifiedName(String qualifiedName, int depth) {
        n = -1;
        if (qualifiedName == null) {
            return null;
        }
        i = 0;
        if (depth > 0) ** GOTO lbl11
        return qualifiedName;
lbl-1000:
        // 1 sources

        {
            if ((n = qualifiedName.indexOf("::", n + 1)) != -1) {
                ++i;
                continue;
            }
            return null;
lbl11:
            // 2 sources

            ** while (i < depth)
        }
lbl12:
        // 1 sources

        if (n == -1) {
            return qualifiedName;
        }
        return qualifiedName.substring(n + 2);
    }

    @Override
    public WrappingLabel getQualifiedNameLabel() {
        return this.qualifiedLabel;
    }

    protected int getIconLabelPosition() {
        return 0;
    }

    protected int getStereotypeLabelPosition() {
        int position = 0;
        if (this.getStereotypeLabelContainer().equals(this.getIconLabelContainer())) {
            position = this.getIconLabelPosition();
            if (this.iconLabel != null && this.iconLabel.getIcon() != null) {
                ++position;
            }
        }
        return position;
    }

    protected int getStereotypePropertiesLabelPosition() {
        int position = 0;
        if (this.getStereotypePropertiesInBraceLabelContainer().equals(this.getStereotypeLabelContainer())) {
            position = this.getStereotypeLabelPosition();
            if (this.stereotypesLabel != null) {
                ++position;
            }
        } else if (this.getStereotypePropertiesInBraceLabelContainer().equals(this.getIconLabelContainer())) {
            position = this.getIconLabelPosition();
            if (this.iconLabel != null && this.iconLabel.getIcon() != null) {
                ++position;
            }
        }
        return position;
    }

    protected int getQualifiedNameLabelPosition() {
        int position = 0;
        if (this.getQualifiedNameLabelContainer().equals(this.getStereotypePropertiesInBraceLabelContainer())) {
            position = this.getStereotypePropertiesLabelPosition();
            if (this.stereotypePropertiesInBraceContent != null) {
                ++position;
            }
        } else if (this.getQualifiedNameLabelContainer().equals(this.getStereotypeLabelContainer())) {
            position = this.getStereotypeLabelPosition();
            if (this.stereotypesLabel != null) {
                ++position;
            }
        } else if (this.getQualifiedNameLabelContainer().equals(this.getIconLabelContainer())) {
            position = this.getIconLabelPosition();
            if (this.iconLabel != null && this.iconLabel.getIcon() != null) {
                ++position;
            }
        }
        return position;
    }

    protected int getNameLabelPosition() {
        int position = 0;
        if (this.getNameLabelContainer().equals(this.getQualifiedNameLabelContainer())) {
            position = this.getQualifiedNameLabelPosition();
            if (this.qualifiedLabel != null) {
                ++position;
            }
        } else if (this.getQualifiedNameLabelContainer().equals(this.getStereotypePropertiesInBraceLabelContainer())) {
            position = this.getStereotypePropertiesLabelPosition();
            if (this.stereotypePropertiesInBraceContent != null) {
                ++position;
            }
        } else if (this.getQualifiedNameLabelContainer().equals(this.getStereotypeLabelContainer())) {
            position = this.getStereotypeLabelPosition();
            if (this.stereotypesLabel != null) {
                ++position;
            }
        } else if (this.getQualifiedNameLabelContainer().equals(this.getIconLabelContainer())) {
            position = this.getIconLabelPosition();
            if (this.iconLabel != null && this.iconLabel.getIcon() != null) {
                ++position;
            }
        }
        return position;
    }

    protected int getStereotypePropertiesCompartmentPosition() {
        int position = 0;
        if (this.getStereotypePropertiesCompartmentContainer().equals(this.getNameLabelContainer())) {
            position = this.getNameLabelContainer().getChildren().indexOf(this.nameLabel);
            ++position;
        } else if (this.getNameLabelContainer().equals(this.getQualifiedNameLabelContainer())) {
            position = this.getQualifiedNameLabelPosition();
            if (this.qualifiedLabel != null) {
                ++position;
            }
        } else if (this.getQualifiedNameLabelContainer().equals(this.getStereotypePropertiesInBraceLabelContainer())) {
            position = this.getStereotypePropertiesLabelPosition();
            if (this.stereotypePropertiesInBraceContent != null) {
                ++position;
            }
        } else if (this.getQualifiedNameLabelContainer().equals(this.getStereotypeLabelContainer())) {
            position = this.getStereotypeLabelPosition();
            if (this.stereotypesLabel != null) {
                ++position;
            }
        } else if (this.getQualifiedNameLabelContainer().equals(this.getIconLabelContainer())) {
            position = this.getIconLabelPosition();
            if (this.iconLabel != null && this.iconLabel.getIcon() != null) {
                ++position;
            }
        }
        return position;
    }

    public RectangleFigure getStereotypePropertiesContent() {
        return this.stereotypePropertiesContent;
    }

    @Override
    public PapyrusWrappingLabel getStereotypesLabel() {
        return this.stereotypesLabel;
    }

    protected boolean labelContainsPoint(Label label, Point pt) {
        PrecisionRectangle rc = new PrecisionRectangle(label.getBounds());
        label.translateToAbsolute((Translatable)rc);
        return rc.contains(pt);
    }

    public void refreshStereotypes(String stereotypes, String presentation, boolean hasIcon, boolean hasShape) {
        if (stereotypes.equals("")) {
            this.setStereotypes(null);
            return;
        }
        if (presentation.equals("IconStereotype") && hasIcon) {
            this.setStereotypes(null);
            return;
        }
        if (presentation.equals("ImageStereotype") && hasShape) {
            this.setStereotypes(null);
            return;
        }
        this.setStereotypes(stereotypes);
    }

    @Override
    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setName(String name) {
        this.nameLabel.setText(name);
    }

    @Override
    public void setNameLabelIcon(boolean displayNameLabelIcon) {
        if (this.getNameLabel().getIcon() != null) {
            this.nameLabelIcon = this.getNameLabel().getIcon();
        }
        if (displayNameLabelIcon) {
            this.getNameLabel().setIcon(this.nameLabelIcon);
        } else {
            this.getNameLabel().setIcon(null);
        }
    }

    public void setNameLabelIcon(Image nameLabelIcon) {
        this.nameLabelIcon = nameLabelIcon;
    }

    @Override
    public void setQualifiedName(String qualifiedName) {
        int i;
        String tmpQualifiedName = this.getQualifiedName(qualifiedName, this.depth);
        if (qualifiedName == null || tmpQualifiedName == null || !tmpQualifiedName.contains("::")) {
            if (this.qualifiedLabel != null) {
                this.getQualifiedNameLabelContainer().remove((IFigure)this.qualifiedLabel);
                this.qualifiedLabel = null;
            }
            return;
        }
        if (this.qualifiedLabel == null) {
            this.createQualifiedNameLabel();
        }
        if ((i = tmpQualifiedName.lastIndexOf("::")) != -1) {
            tmpQualifiedName = tmpQualifiedName.substring(0, i);
        }
        this.qualifiedLabel.setText("(" + tmpQualifiedName.trim() + ")");
    }

    @Override
    public void setStereotypePropertiesInBrace(String stereotypeProperties) {
        if (stereotypeProperties == null) {
            if (this.stereotypePropertiesInBraceContent != null) {
                this.getStereotypePropertiesInBraceLabelContainer().remove((IFigure)this.stereotypePropertiesInBraceContent);
                this.stereotypePropertiesInBraceContent = null;
            }
            return;
        }
        if (this.stereotypePropertiesInBraceContent == null) {
            this.createStereotypePropertiesInBraceLabel();
        }
        if (!"".equals(stereotypeProperties)) {
            this.stereotypePropertiesInBraceContent.setText("{" + stereotypeProperties + "}");
        } else {
            this.stereotypePropertiesInBraceContent.setText("");
        }
    }

    @Override
    public void setStereotypePropertiesInCompartment(String stereotypeProperties) {
        if (stereotypeProperties == null || "".equals(stereotypeProperties.trim())) {
            if (this.stereotypePropertiesContent != null) {
                this.getStereotypePropertiesCompartmentContainer().remove((IFigure)this.stereotypePropertiesContent);
                this.stereotypePropertiesContent = null;
            }
            return;
        }
        if (this.stereotypePropertiesContent == null) {
            this.createStereotypePropertiesContent();
        }
        this.fillStereotypePropertiesInCompartment(stereotypeProperties);
    }

    public void setStereotypes(String stereotypes) {
        if (stereotypes == null) {
            if (this.stereotypesLabel != null && this.getStereotypeLabelContainer().getChildren().contains(this.stereotypesLabel)) {
                this.getStereotypeLabelContainer().remove((IFigure)this.stereotypesLabel);
                this.stereotypesLabel = null;
            }
            return;
        }
        if (this.stereotypesLabel == null) {
            this.createStereotypeLabel();
        }
        if (!"".equals(stereotypes)) {
            this.stereotypesLabel.setText(stereotypes);
        } else {
            this.stereotypesLabel.setText("");
        }
    }

    public void setAppliedStereotypeIcon(Image image) {
        if (image == null) {
            if (this.iconLabel != null) {
                this.getIconLabelContainer().remove((IFigure)this.iconLabel);
                this.iconLabel = null;
            }
            return;
        }
        if (this.iconLabel == null) {
            this.createIconLabel();
        }
        this.iconLabel.setIcon(image);
    }

    public void setAppliedStereotypeIcon(Image image, int position) {
        if (image == null) {
            if (this.iconLabel != null) {
                this.getIconLabelContainer().remove((IFigure)this.iconLabel);
                this.iconLabel = null;
            }
            return;
        }
        if (this.iconLabel == null) {
            this.createIconLabel(position);
        }
        this.iconLabel.setIcon(image);
    }

    public void setLabelHeight(int labelHeight) {
        this.nameLabel.setLabelHeight(labelHeight);
    }

    public void setLabelWidth(int labelWidth) {
        this.nameLabel.setLabelWidth(labelWidth);
    }

    public void setLabelSize(int width, int height) {
        this.nameLabel.setLabelSize(width, height);
    }
}

