/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.handles.MoveHandleLocator;
import org.eclipse.gef.handles.RelativeHandleLocator;
import org.eclipse.gef.handles.ResizeHandle;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.ResizeTracker;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.SemanticFromGMFElement;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.PapyrusResizableShapeEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractMessageEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.figures.LifelineFigure;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineEditPartUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineMessageDeleteHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class LifelineSelectionEditPolicy
extends PapyrusResizableShapeEditPolicy {
    Point maxMoveDelta;

    public LifelineSelectionEditPolicy() {
        this.setResizeDirections(28);
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        LifelineEditPart llEditPart = (LifelineEditPart)this.getHost();
        if (!LifelineMessageDeleteHelper.hasIncomingMessageDelete((EditPart)llEditPart)) {
            Dimension sizeDelta = request.getSizeDelta();
            int moveHeight = sizeDelta.height();
            if (moveHeight != 0) {
                Rectangle absoluteBounds = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)llEditPart);
                Point pointFromWhichOneSearch = new Point(absoluteBounds.x + absoluteBounds.width / 2, absoluteBounds.y + absoluteBounds.height);
                int maxY = this.getLastPointOfLifeLineChildren(llEditPart, pointFromWhichOneSearch);
                if (maxY > absoluteBounds.y + absoluteBounds.height() + moveHeight) {
                    return null;
                }
            }
            return super.getResizeCommand(request);
        }
        return null;
    }

    protected int getLastPointOfLifeLineChildren(LifelineEditPart lifelineEditPart, Point pointFromWhichOneSearch) {
        int maxY = 0;
        List<OccurrenceSpecification> previousEvents = LifelineEditPartUtil.getPreviousEventsFromPosition(pointFromWhichOneSearch, lifelineEditPart);
        if (previousEvents != null && !previousEvents.isEmpty()) {
            EObject element;
            Message message;
            IGraphicalEditPart editPart;
            OccurrenceSpecification lastPreviousEvent = previousEvents.get(previousEvents.size() - 1);
            if (lastPreviousEvent instanceof ExecutionOccurrenceSpecification) {
                Rectangle absoluteBounds;
                EObject element2;
                ExecutionSpecification execSpec = ((ExecutionOccurrenceSpecification)lastPreviousEvent).getExecution();
                IGraphicalEditPart editPart2 = this.getEditPartFromSemantic(execSpec);
                if (editPart2 instanceof AbstractExecutionSpecificationEditPart && (element2 = ((View)((AbstractExecutionSpecificationEditPart)editPart2).getAdapter(View.class)).getElement()) instanceof ExecutionSpecification && ((ExecutionSpecification)element2).getStart() != null && ((ExecutionSpecification)element2).getStart().equals(lastPreviousEvent) && maxY < absoluteBounds.y + (absoluteBounds = SequenceUtil.getAbsoluteBounds(editPart2)).height()) {
                    maxY = absoluteBounds.y + absoluteBounds.height();
                }
            } else if (lastPreviousEvent instanceof MessageOccurrenceSpecification && (editPart = this.getEditPartFromSemantic(message = ((MessageOccurrenceSpecification)lastPreviousEvent).getMessage())) instanceof ConnectionEditPart && ((element = ((View)((AbstractMessageEditPart)editPart).getAdapter(View.class)).getElement()) instanceof Message && ((Message)element).getSendEvent() != null && ((Message)element).getSendEvent().equals(lastPreviousEvent) || element instanceof Message && ((Message)element).getReceiveEvent() != null && ((Message)element).getReceiveEvent().equals(lastPreviousEvent))) {
                PolylineConnectionEx polyline = (PolylineConnectionEx)((ConnectionEditPart)editPart).getFigure();
                Point anchorPositionOnScreen = ((Message)element).getSendEvent().equals(lastPreviousEvent) ? polyline.getSourceAnchor().getReferencePoint() : polyline.getTargetAnchor().getReferencePoint();
                if (maxY < anchorPositionOnScreen.y) {
                    maxY = anchorPositionOnScreen.y;
                }
            }
        }
        return maxY;
    }

    protected IGraphicalEditPart getEditPartFromSemantic(Object semanticElement) {
        IGraphicalEditPart researchedEditPart = null;
        SemanticFromGMFElement semanticFromGMFElement = new SemanticFromGMFElement();
        EditPartViewer editPartViewer = this.getHost().getViewer();
        if (editPartViewer != null) {
            Iterator iter = editPartViewer.getEditPartRegistry().values().iterator();
            while (iter.hasNext() && researchedEditPart == null) {
                Object currentElement;
                Object currentEditPart = iter.next();
                if (!(currentEditPart instanceof IPrimaryEditPart) || !semanticElement.equals(currentElement = semanticFromGMFElement.getSemanticElement(currentEditPart))) continue;
                researchedEditPart = (IGraphicalEditPart)currentEditPart;
            }
        }
        return researchedEditPart;
    }

    protected List<?> createSelectionHandles() {
        LifelineEditPart host = (LifelineEditPart)this.getHost();
        LifelineFigure primaryShape = host.getPrimaryShape();
        ArrayList<Handle> list = new ArrayList<Handle>();
        RectangleFigure figure = primaryShape.getFigureLifelineNameContainerFigure();
        MoveHandleLocator locator = new MoveHandleLocator((IFigure)figure);
        MoveHandle moveHandle = new MoveHandle(this.getHost(), (Locator)locator);
        figure.addFigureListener(new FigureListener((Locator)locator, moveHandle){
            private final /* synthetic */ Locator val$locator;
            private final /* synthetic */ MoveHandle val$moveHandle;
            {
                this.val$locator = locator;
                this.val$moveHandle = moveHandle;
            }

            public void figureMoved(IFigure source) {
                this.val$locator.relocate((IFigure)this.val$moveHandle);
            }
        });
        moveHandle.setCursor(Cursors.SIZEALL);
        list.add((Handle)moveHandle);
        RectangleFigure fig = primaryShape.getFigureLifelineNameContainerFigure();
        this.createResizeHandle(host, list, (IFigure)fig, 8);
        this.createResizeHandle(host, list, (IFigure)fig, 16);
        this.createResizeHandle(host, list, (IFigure)primaryShape, 4);
        return list;
    }

    private void createResizeHandle(LifelineEditPart host, List<Handle> list, IFigure fig, int location) {
        RelativeHandleLocator locator = new RelativeHandleLocator(fig, location);
        Cursor cursor = Cursors.getDirectionalCursor((int)location, (boolean)fig.isMirrored());
        ResizeHandle westResizer = new ResizeHandle((GraphicalEditPart)host, (Locator)locator, cursor);
        ResizeTracker resizeTracker = new ResizeTracker((GraphicalEditPart)host, location);
        westResizer.setDragTracker((DragTracker)resizeTracker);
        RectangleFigure figure = host.getPrimaryShape().getFigureLifelineNameContainerFigure();
        figure.addFigureListener(new FigureListener((Locator)locator, westResizer){
            private final /* synthetic */ Locator val$locator;
            private final /* synthetic */ ResizeHandle val$westResizer;
            {
                this.val$locator = locator;
                this.val$westResizer = resizeHandle;
            }

            public void figureMoved(IFigure source) {
                this.val$locator.relocate((IFigure)this.val$westResizer);
            }
        });
        list.add((Handle)westResizer);
    }

    private void keepNameLabelBounds(LifelineEditPart lifelineEP, ChangeBoundsRequest request, PrecisionRectangle rect) {
        PrecisionRectangle size = this.getMovedRectangle(rect, request);
        Dimension preferSize = lifelineEP.getPrimaryShape().getFigureLifelineNameContainerFigure().getPreferredSize(-1, -1).getCopy();
        this.getHostFigure().translateToAbsolute((Translatable)preferSize);
        if (size.width < preferSize.width) {
            request.getSizeDelta().width = preferSize.width - rect.width;
            if (request.getMoveDelta().x > 0) {
                request.getMoveDelta().x = rect.width - preferSize.width;
            }
        }
    }

    protected Rectangle getCurrentConstraintFor(GraphicalEditPart child) {
        IFigure fig = child.getFigure();
        return (Rectangle)fig.getParent().getLayoutManager().getConstraint(fig);
    }

    private void keepInParentBounds(LifelineEditPart lifelineEP, ChangeBoundsRequest request, PrecisionRectangle rect) {
        block16: {
            PrecisionRectangle c;
            Rectangle p;
            LifelineEditPart parent;
            block18: {
                int delta;
                block17: {
                    if (!(lifelineEP.getParent() instanceof LifelineEditPart)) break block16;
                    parent = (LifelineEditPart)lifelineEP.getParent();
                    p = parent.getFigure().getBounds().getCopy();
                    parent.getFigure().translateToAbsolute((Translatable)p);
                    c = this.getMovedRectangle(rect, request);
                    Dimension preferSize = this.getHostFigure().getPreferredSize();
                    this.getHostFigure().translateToAbsolute((Translatable)preferSize);
                    if (!request.getType().equals("resize")) break block17;
                    switch (request.getResizeDirection()) {
                        case 8: {
                            if (c.getLeft().x <= p.getLeft().x) {
                                delta = p.getLeft().x - c.getLeft().x;
                                request.getMoveDelta().x += delta;
                                request.getSizeDelta().width -= delta;
                                break;
                            }
                            break block18;
                        }
                        case 16: {
                            if (c.getRight().x + request.getSizeDelta().width < p.getRight().x) break block18;
                            delta = c.getRight().x - p.getRight().x;
                            request.getSizeDelta().width -= delta;
                        }
                        default: {
                            break;
                        }
                        {
                        }
                    }
                    break block18;
                }
                if (c.getLeft().x <= p.getLeft().x) {
                    delta = p.getLeft().x - c.getLeft().x;
                    request.getMoveDelta().x += delta;
                } else if (c.getRight().x >= p.getRight().x) {
                    delta = c.getRight().x - p.getRight().x;
                    request.getMoveDelta().x -= delta;
                }
            }
            c = this.getMovedRectangle(rect, request);
            Rectangle other = this.getLifelineIntersectBounds(lifelineEP, parent, request, c);
            if (other != null) {
                if (request.getSizeDelta().width == 0) {
                    request.getMoveDelta().x = request.getMoveDelta().x > 0 ? (p.right() - other.right() > 0 ? other.getRight().x - rect.getLeft().x : 0) : (other.x - p.x > 0 ? other.getLeft().x - rect.getRight().x : 0);
                } else if (request.getMoveDelta().x == 0) {
                    request.getSizeDelta().width = other.getLeft().x - rect.getRight().x;
                } else {
                    request.getMoveDelta().x = other.getRight().x - rect.getLeft().x;
                    request.getSizeDelta().width = -request.getMoveDelta().x;
                }
            }
        }
    }

    private Rectangle getLifelineIntersectBounds(LifelineEditPart lifelineEP, LifelineEditPart parent, ChangeBoundsRequest request, PrecisionRectangle rect) {
        List children = parent.getChildren();
        for (Object o : children) {
            if (!(o instanceof LifelineEditPart) || o == lifelineEP) continue;
            LifelineEditPart p = (LifelineEditPart)((Object)o);
            Rectangle bounds = p.getFigure().getBounds().getCopy();
            p.getFigure().translateToAbsolute((Translatable)bounds);
            if (!bounds.intersects((Rectangle)rect)) continue;
            return bounds;
        }
        return null;
    }

    private PrecisionRectangle getMovedRectangle(PrecisionRectangle rect, ChangeBoundsRequest request) {
        PrecisionRectangle c = rect.getPreciseCopy();
        c.translate(request.getMoveDelta());
        c.resize(request.getSizeDelta());
        return c;
    }

    private void changeCombinedFragmentBounds(ChangeBoundsRequest request, LifelineEditPart lifelineEP) {
        if (request.getMoveDelta().x > 0) {
            return;
        }
        View shape = (View)lifelineEP.getModel();
        Lifeline element = (Lifeline)shape.getElement();
        EList covereds = element.getCoveredBys();
        EditPart parent = lifelineEP.getParent();
        List children = parent.getChildren();
        Rectangle bounds = lifelineEP.getFigure().getBounds().getCopy();
        bounds.translate(request.getMoveDelta());
        Point center = bounds.getCenter();
        for (Object obj : children) {
            CombinedFragmentEditPart et;
            View sp;
            if (!(obj instanceof CombinedFragmentEditPart) || !covereds.contains((Object)(sp = (View)(et = (CombinedFragmentEditPart)((Object)obj)).getModel()).getElement())) continue;
            Rectangle rect = et.getFigure().getBounds();
            if (rect.x < center.x && rect.right() > center.x) continue;
            this.changeCombinedFragmentBounds(request, et, lifelineEP);
        }
    }

    protected void eraseChangeBoundsFeedback(ChangeBoundsRequest request) {
        super.eraseChangeBoundsFeedback(request);
        this.maxMoveDelta = null;
    }

    void changeCombinedFragmentBounds(ChangeBoundsRequest request, CombinedFragmentEditPart cep, LifelineEditPart lifelineEP) {
        Rectangle rect = this.getTransformedRectangle(cep, request);
        if (rect.x <= 0) {
            if (this.maxMoveDelta != null) {
                request.getMoveDelta().x = this.maxMoveDelta.x;
            } else {
                Point p = new Point(Math.abs(rect.x), 0);
                cep.getFigure().translateToAbsolute((Translatable)p);
                request.getMoveDelta().x = Math.min(0, request.getMoveDelta().x + p.x);
                this.maxMoveDelta = request.getMoveDelta().getCopy();
            }
        }
    }

    private Rectangle getTransformedRectangle(CombinedFragmentEditPart cep, ChangeBoundsRequest request) {
        PrecisionRectangle rect = new PrecisionRectangle(cep.getFigure().getBounds());
        cep.getFigure().translateToAbsolute((Translatable)rect);
        rect = request.getTransformedRectangle((Rectangle)rect);
        cep.getFigure().translateToRelative((Translatable)rect);
        return rect;
    }
}

