/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;

public class BooleanTypeCompiler
extends BaseTypeCompiler {
    @Override
    public boolean convertible(TypeId otherType, boolean forDataTypeFunction) {
        return otherType.isStringTypeId() || otherType.isBooleanTypeId();
    }

    @Override
    public boolean compatible(TypeId otherType) {
        return this.convertible(otherType, false);
    }

    @Override
    public boolean storable(TypeId otherType, ClassFactory cf) {
        if (otherType.isBooleanTypeId() || otherType.isStringTypeId()) {
            return true;
        }
        return this.userTypeStorable(this.getTypeId(), otherType, cf);
    }

    @Override
    public String interfaceName() {
        return "org.apache.derby.iapi.types.BooleanDataValue";
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        return "boolean";
    }

    @Override
    public String getPrimitiveMethodName() {
        return "getBoolean";
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dts) {
        return 5;
    }

    @Override
    String nullMethodName() {
        return "getNullBoolean";
    }
}

