/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndication;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.RevisionInfo;

public class LoadRevisionByVersionIndication
extends CDOServerReadIndication {
    private CDOID id;
    private CDOBranchVersion branchVersion;
    private int referenceChunk;

    public LoadRevisionByVersionIndication(CDOServerProtocol protocol) {
        super(protocol, (short)8);
    }

    @Override
    protected void indicating(CDODataInput in) throws IOException {
        this.id = in.readCDOID();
        this.branchVersion = in.readCDOBranchVersion();
        this.referenceChunk = in.readXInt();
    }

    @Override
    protected void responding(CDODataOutput out) throws IOException {
        InternalCDORevisionManager revisionManager = this.getRepository().getRevisionManager();
        InternalCDORevision revision = revisionManager.getRevisionByVersion(this.id, this.branchVersion, this.referenceChunk, true);
        RevisionInfo.writeResult((CDODataOutput)out, (InternalCDORevision)revision, (boolean)true, (int)this.referenceChunk, null);
    }
}

