/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.db;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.tests.db.DBConfig;
import org.eclipse.emf.cdo.tests.db.bundle.OM;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.h2.H2Adapter;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.io.TMPUtil;
import org.h2.jdbcx.JdbcDataSource;

public class H2Config
extends DBConfig {
    public static final String DB_ADAPTER_NAME = "H2";
    private static final long serialVersionUID = 1L;
    private static final Boolean disableRepositoryRecreationOptimization = Boolean.getBoolean("org.eclipse.emf.cdo.tests.db.H2Config.disableRepositoryRecreationOptimization");
    private static File reusableFolder;
    private static JdbcDataSource defaultDataSource;
    private static final Map<String, Connection> leakyConnections;

    static {
        leakyConnections = new HashMap<String, Connection>();
    }

    public H2Config() {
        super(DB_ADAPTER_NAME);
    }

    @Override
    protected String getDBAdapterName() {
        return DB_ADAPTER_NAME;
    }

    @Override
    protected IDBAdapter createDBAdapter() {
        return new H2Adapter();
    }

    protected File createDBFolder() {
        return TMPUtil.createTempFolder((String)"h2_", (String)"_test");
    }

    @Override
    protected DataSource createDataSource(String repoName) {
        if (reusableFolder == null) {
            reusableFolder = this.createDBFolder();
            IOUtil.delete((File)reusableFolder);
        }
        String url = "jdbc:h2:" + reusableFolder.getAbsolutePath() + "/h2test;LOCK_TIMEOUT=10000;TRACE_LEVEL_FILE=0";
        if (defaultDataSource == null) {
            defaultDataSource = new JdbcDataSource();
            defaultDataSource.setURL(url);
        }
        String schemaName = DBUtil.name((String)repoName);
        H2Adapter.createSchema((DataSource)defaultDataSource, (String)schemaName, (!this.isRestarting() ? 1 : 0) != 0);
        JdbcDataSource dataSource = new JdbcDataSource();
        dataSource.setURL(url + ";SCHEMA=" + DBUtil.quoted((String)schemaName));
        if (!disableRepositoryRecreationOptimization.booleanValue()) {
            this.optimizeRepositoryRecreation(repoName, dataSource);
        }
        return dataSource;
    }

    @Override
    protected Map<String, String> createStoreProperties(String repoName) {
        Map<String, String> props = super.createStoreProperties(repoName);
        props.put("schemaName", repoName);
        props.put("prependSchemaName", Boolean.TRUE.toString());
        return props;
    }

    private void optimizeRepositoryRecreation(String repoName, JdbcDataSource dataSource) {
        Connection leakyConnection = leakyConnections.get(repoName);
        if (leakyConnection == null) {
            try {
                leakyConnection = dataSource.getConnection();
                leakyConnections.put(repoName, leakyConnection);
            }
            catch (SQLException ex) {
                OM.LOG.info((Throwable)ex);
            }
        }
    }

    public void mainSuiteFinished() throws Exception {
        for (Connection leakyConnection : leakyConnections.values()) {
            leakyConnection.close();
        }
        leakyConnections.clear();
        this.deactivateRepositories();
        if (reusableFolder != null) {
            IOUtil.delete((File)reusableFolder);
            reusableFolder = null;
        }
    }
}

