/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ecore.dependencies.ui;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.cdo.ecore.dependencies.Addressable;
import org.eclipse.emf.cdo.ecore.dependencies.Element;
import org.eclipse.emf.cdo.ecore.dependencies.Link;
import org.eclipse.emf.cdo.ecore.dependencies.Model;
import org.eclipse.emf.cdo.ecore.dependencies.ModelContainer;
import org.eclipse.emf.cdo.ecore.dependencies.bundle.DependenciesPlugin;
import org.eclipse.emf.cdo.ecore.dependencies.provider.DependenciesItemProviderAdapterFactory;
import org.eclipse.emf.cdo.ecore.dependencies.provider.ModelItemProviderForLinkViewer;
import org.eclipse.emf.cdo.ecore.dependencies.provider.URIStyler;
import org.eclipse.emf.cdo.ecore.dependencies.ui.TableColumnSorter;
import org.eclipse.emf.cdo.ecore.dependencies.util.WorkspaceScanner;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.DelegatingStyledCellLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.om.pref.OMPreference;
import org.eclipse.net4j.util.ui.widgets.SashComposite;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ViewPart;

public class DependenciesView
extends ViewPart
implements ISelectionProvider {
    public static final String ID = "org.eclipse.emf.cdo.ecore.DependenciesView";
    private static final String ECORE_EDITOR_ID = "org.eclipse.emf.ecore.presentation.EcoreEditorID";
    private static final String XML_EDITOR_ID = "org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart";
    private static final String TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    private static final String[] FILE_NAME_PATTERNS = new String[]{"*.ecore"};
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final List<ISelectionChangedListener> selectionChangedListeners = new CopyOnWriteArrayList<ISelectionChangedListener>();
    private final ISelectionChangedListener currentViewerListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            DependenciesView.this.setSelection(selectionChangedEvent.getSelection());
        }
    };
    private final IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (this.hasModelImpact(delta)) {
                DependenciesView.this.modelViewer.getControl().getDisplay().asyncExec(() -> DependenciesView.this.setInput());
            }
        }

        private boolean hasModelImpact(IResourceDelta delta) {
            IResource resource = delta.getResource();
            if (resource.getType() == 1) {
                return "ecore".equals(resource.getFileExtension());
            }
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta childDelta = iResourceDeltaArray[n2];
                if (this.hasModelImpact(childDelta)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    };
    private final ComposedAdapterFactory modelAdapterFactory = new ComposedAdapterFactory(EMFEditPlugin.getComposedAdapterFactoryDescriptorRegistry());
    private final ComposedAdapterFactory linkAdapterFactory = new ComposedAdapterFactory(EMFEditPlugin.getComposedAdapterFactoryDescriptorRegistry()){
        {
            this.addAdapterFactory((AdapterFactory)new DependenciesItemProviderAdapterFactory(){

                @Override
                public Adapter createModelAdapter() {
                    return new ModelItemProviderForLinkViewer((AdapterFactory)this);
                }
            });
        }
    };
    private final Action calleesAction = new PreferenceAction("Callees", "Callees", DependenciesPlugin.PREF_SHOW_CALLERS, false);
    private final Action callersAction = new PreferenceAction("Callers", "Callers", DependenciesPlugin.PREF_SHOW_CALLERS, true);
    private final Action flatAction = new PreferenceAction("Flat", "Flat", DependenciesPlugin.PREF_SHOW_FLAT, null);
    private final Action sortByDependenciesAction = new PreferenceAction("Sort By Dependencies", "SortByDependencies", DependenciesPlugin.PREF_SORT_BY_DEPENDENCIES, null);
    private final Action showBrokenLinksAction = new PreferenceAction("Show Broken Links", "BrokenLink", DependenciesPlugin.PREF_SHOW_BROKEN_LINKS, null);
    private final Action showGenericsAction = new PreferenceAction("Show Generics", "Generics", DependenciesPlugin.PREF_SHOW_GENERICS, null);
    private final Action layoutVerticalAction = new PreferenceAction(this, "Layout Vertical", "Vertical", DependenciesPlugin.PREF_LAYOUT_VERTICAL, true){

        @Override
        protected void run(boolean value) {
            sashComposite.setVertical(value);
        }
    };
    private final Action layoutHorizontalAction = new PreferenceAction(this, "Layout Horizontal", "Horizontal", DependenciesPlugin.PREF_LAYOUT_VERTICAL, false){

        @Override
        protected void run(boolean value) {
            sashComposite.setVertical(value);
        }
    };
    private final Action toggleXMLAction = new DefaultAction("Use XML Editor", "Xml", 2);
    private final Action refreshAction = new DefaultAction(this, "Refresh", "Refresh", 1){

        @Override
        public void run() {
            this.refreshViewers();
        }
    };
    private final Action copyURIAction = new AbstractCopyAction(this, "Copy URI", "Copy"){

        @Override
        protected String getText(IStructuredSelection selection) {
            StringBuilder builder = new StringBuilder();
            for (Object element : selection) {
                Addressable addressable;
                URI uri;
                if (!(element instanceof Addressable) || (uri = (addressable = (Addressable)element).getUri()) == null) continue;
                if (builder.length() != 0) {
                    builder.append(LINE_SEPARATOR);
                }
                builder.append(uri);
            }
            return builder.toString();
        }
    };
    private final Action copyPathAction = new AbstractCopyAction(this, "Copy Path", "Copy"){

        @Override
        protected String getText(IStructuredSelection selection) {
            StringBuilder builder = new StringBuilder();
            for (Object element : selection) {
                Model model;
                IFile file;
                if (!(element instanceof Model) || (file = (model = (Model)element).getFile()) == null) continue;
                if (builder.length() != 0) {
                    builder.append(LINE_SEPARATOR);
                }
                builder.append(file.getFullPath());
            }
            return builder.toString();
        }
    };
    private final Action searchAction = new DefaultAction(this, "Search URI", "Search", 1){

        @Override
        public void run() {
            try {
                Object element = modelViewer.getStructuredSelection().getFirstElement();
                if (element instanceof Addressable) {
                    String uri = Addressable.getAlphaKey((Addressable)element);
                    if (uri.startsWith("platform:/plugin")) {
                        uri = uri.substring("platform:/plugin".length());
                    } else if (uri.startsWith("platform:/resource")) {
                        uri = uri.substring("platform:/resource".length());
                    }
                    FileSearchQuery query = new FileSearchQuery(uri, false, true, FileTextSearchScope.newWorkspaceScope((String[])FILE_NAME_PATTERNS, (boolean)false));
                    NewSearchUI.runQueryInBackground((ISearchQuery)query);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    };
    private final Action doubleClickAction = new Action("Open"){

        public void run() {
            Object element = DependenciesView.this.modelViewer.getStructuredSelection().getFirstElement();
            try {
                if (element instanceof Model) {
                    URI uri;
                    Model model = (Model)element;
                    FileEditorInput input = null;
                    IFile file = model.getFile();
                    if (file != null) {
                        input = new FileEditorInput(file);
                    }
                    if (input == null && (uri = model.getUri()) != null && uri.isPlatform()) {
                        input = new URIEditorInput(uri);
                    }
                    if (input != null) {
                        DependenciesView.this.page.openEditor((IEditorInput)input, DependenciesView.this.toggleXMLAction.isChecked() && input instanceof FileEditorInput ? DependenciesView.this.xmlEditorID : DependenciesView.ECORE_EDITOR_ID, true, 1);
                        return;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            DependenciesView.this.searchAction.run();
        }
    };
    private IWorkbenchPage page;
    private SashComposite sashComposite;
    private StructuredViewer currentViewer;
    private TreeViewer modelViewer;
    private TableViewer linkViewer;
    private String xmlEditorID;
    private ISelection viewSelection;

    public ISelection getSelection() {
        return this.viewSelection;
    }

    public void setSelection(ISelection selection) {
        this.viewSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
        this.setStatusLineManager(selection);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    private void setStatusLineManager(ISelection selection) {
        IActionBars bars = this.getViewSite().getActionBars();
        IStatusLineManager statusLineManager = bars.getStatusLineManager();
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(DependenciesView.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        String text = new AdapterFactoryItemDelegator((AdapterFactory)this.modelAdapterFactory).getText(collection.iterator().next());
                        statusLineManager.setMessage(DependenciesView.getString("_UI_SingleObjectSelected", text));
                        break;
                    }
                    default: {
                        statusLineManager.setMessage(DependenciesView.getString("_UI_MultiObjectSelected", Integer.toString(collection.size())));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    public void createPartControl(Composite parent) {
        this.page = this.getViewSite().getPage();
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        this.xmlEditorID = editorRegistry.findEditor(XML_EDITOR_ID) != null ? XML_EDITOR_ID : TEXT_EDITOR_ID;
        boolean vertical = (Boolean)DependenciesPlugin.PREF_LAYOUT_VERTICAL.getValue();
        this.sashComposite = new SashComposite(parent, 0, 100, 50, false, vertical, false){

            protected Control createControl1(Composite parent) {
                return DependenciesView.this.createModelViewer(parent);
            }

            protected Sash createSash(Composite parent) {
                Sash sash = super.createSash(parent);
                sash.setBackground(parent.getShell().getBackground());
                return sash;
            }

            protected Control createControl2(Composite parent) {
                return DependenciesView.this.createLinkViewer(parent);
            }
        };
        this.sashComposite.addListener(new IListener(){

            public void notifyEvent(IEvent event) {
                if (event instanceof SashComposite.OrientationChangedEvent) {
                    SashComposite.OrientationChangedEvent e = (SashComposite.OrientationChangedEvent)event;
                    DependenciesPlugin.PREF_LAYOUT_VERTICAL.setValue((Object)e.isVertical());
                }
            }
        });
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.setInput();
        this.setCurrentViewer((StructuredViewer)this.modelViewer);
        this.modelViewer.getTree().setFocus();
        this.getViewSite().setSelectionProvider((ISelectionProvider)this);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener(this.resourceChangeListener);
    }

    private Control createModelViewer(Composite parent) {
        this.modelViewer = new TreeViewer(parent, 770);
        this.modelViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.modelAdapterFactory));
        this.modelViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new AdapterFactoryLabelProvider.StyledLabelProvider((AdapterFactory)this.modelAdapterFactory, (Viewer)this.modelViewer)));
        this.modelViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = event.getStructuredSelection();
                Object element = selection.getFirstElement();
                DependenciesView.this.linkViewer.setInput(selection.size() == 1 && element instanceof Model ? element : null);
            }
        });
        Tree tree = this.modelViewer.getTree();
        tree.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DependenciesView.this.setCurrentViewer((StructuredViewer)DependenciesView.this.modelViewer);
            }
        });
        return tree;
    }

    private Control createLinkViewer(Composite parent) {
        this.linkViewer = new TableViewer(parent, 770);
        this.linkViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.linkAdapterFactory));
        TableViewerColumn elementViewerColumn = new TableViewerColumn(this.linkViewer, 0);
        elementViewerColumn.getColumn().setText("Element");
        elementViewerColumn.getColumn().setWidth(300);
        elementViewerColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new LinkLabelProvider(){

            public StyledString getStyledText(Object element) {
                StyledString styledString = new StyledString();
                Link link = (Link)element;
                styledString.append(link.getUri().fragment());
                return styledString;
            }
        }));
        TableViewerColumn referenceViewerColumn = new TableViewerColumn(this.linkViewer, 0);
        referenceViewerColumn.getColumn().setText("Reference");
        referenceViewerColumn.getColumn().setWidth(150);
        referenceViewerColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new LinkLabelProvider(){

            public StyledString getStyledText(Object element) {
                StyledString styledString = new StyledString();
                Link link = (Link)element;
                styledString.append(link.getReference().getName());
                return styledString;
            }
        }));
        TableViewerColumn targetViewerColumn = new TableViewerColumn(this.linkViewer, 0);
        targetViewerColumn.getColumn().setText("Target");
        targetViewerColumn.getColumn().setWidth(600);
        targetViewerColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new LinkLabelProvider(){

            public StyledString getStyledText(Object element) {
                URI uri;
                Link link = (Link)element;
                Element target = link.getTarget();
                if (target != null && (uri = target.getUri()) != null) {
                    if (link.isBroken()) {
                        return URIStyler.getJFaceStyledURI(uri, 2);
                    }
                    if (!target.getModel().isWorkspace()) {
                        return URIStyler.getJFaceStyledURI(uri, 1);
                    }
                    return URIStyler.getJFaceStyledURI(uri, 0);
                }
                return new StyledString();
            }
        }));
        new TableColumnSorter(this.linkViewer);
        Table table = this.linkViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DependenciesView.this.setCurrentViewer((StructuredViewer)DependenciesView.this.linkViewer);
            }
        });
        URIStyler.setDefaultFont(table.getFont());
        return table;
    }

    private void setInput() {
        ModelContainer container = WorkspaceScanner.scanWorkspace();
        this.modelViewer.setInput((Object)container);
    }

    private void setCurrentViewer(StructuredViewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.currentViewerListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.currentViewerListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    private void refreshViewers() {
        this.modelViewer.refresh();
        this.linkViewer.refresh();
    }

    public void setFocus() {
        this.modelViewer.getControl().setFocus();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DependenciesView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.modelViewer.getControl());
        this.modelViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.modelViewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyURIAction);
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.calleesAction);
        manager.add((IAction)this.callersAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.flatAction);
        manager.add((IAction)this.sortByDependenciesAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.showBrokenLinksAction);
        manager.add((IAction)this.showGenericsAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.searchAction);
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.toggleXMLAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.copyURIAction);
        manager.add((IAction)this.copyPathAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.layoutVerticalAction);
        manager.add((IAction)this.layoutHorizontalAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.refreshAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void hookDoubleClickAction() {
        this.modelViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DependenciesView.this.doubleClickAction.run();
            }
        });
    }

    private static String getString(String key) {
        return DependenciesPlugin.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return DependenciesPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    private abstract class AbstractCopyAction
    extends DefaultAction {
        public AbstractCopyAction(String text, String iconKey) {
            super(text, iconKey, 1);
        }

        @Override
        public void run() {
            String text = this.getText((IStructuredSelection)DependenciesView.this.modelViewer.getStructuredSelection());
            Clipboard clipboard = new Clipboard(DependenciesView.this.modelViewer.getControl().getDisplay());
            clipboard.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
            clipboard.dispose();
        }

        protected abstract String getText(IStructuredSelection var1);
    }

    private class DefaultAction
    extends Action {
        public DefaultAction(String text, String iconKey, int style) {
            super(text, style);
            if (iconKey != null) {
                this.setImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor((Object)URI.createPlatformPluginURI((String)("org.eclipse.emf.cdo.ecore.dependencies/icons/full/obj16/" + iconKey + ".gif"), (boolean)true)));
            }
        }

        public void run() {
        }
    }

    protected static abstract class LinkLabelProvider
    extends ColumnLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    }

    private class PreferenceAction
    extends DefaultAction {
        private final OMPreference<Boolean> preference;
        private final Boolean value;

        public PreferenceAction(String text, String iconKey, OMPreference<Boolean> preference, Boolean value) {
            super(text, iconKey, value != null ? 8 : 2);
            this.preference = preference;
            this.value = value;
            boolean pref = (Boolean)preference.getValue();
            if (value != null) {
                this.setChecked(pref == value);
            } else {
                this.setChecked(pref);
            }
        }

        @Override
        public final void run() {
            boolean checked = this.isChecked();
            if (this.value != null) {
                if (checked) {
                    this.preference.setValue((Object)this.value);
                    this.run(this.value);
                }
            } else {
                this.preference.setValue((Object)checked);
                this.run(checked);
            }
        }

        protected void run(boolean value) {
            DependenciesView.this.refreshViewers();
        }
    }
}

