/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.internal;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.lsp4e.internal.AbstractLSPCodeMiningProvider;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class AbstractLSPCodeMiningProviderTest
extends AbstractTestWithProject {
    AbstractLSPCodeMiningProviderTest() {
    }

    @Test
    void cancelsPreviousRequestForSameDocument() throws Exception {
        IFile file = TestUtils.createUniqueTestFile(this.project, "txt", "content");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        StubProvider provider = new StubProvider();
        CompletableFuture first = provider.provideCodeMinings(viewer, (IProgressMonitor)new NullProgressMonitor());
        Assertions.assertNotNull((Object)first);
        Assertions.assertFalse((boolean)first.isCancelled(), (String)"first request should start uncancelled");
        CompletableFuture second = provider.provideCodeMinings(viewer, (IProgressMonitor)new NullProgressMonitor());
        Assertions.assertNotNull((Object)second);
        Assertions.assertTrue((boolean)first.isCancelled(), (String)"previous request should be cancelled when a new one starts");
        Assertions.assertFalse((boolean)second.isCancelled(), (String)"new request should remain active");
    }

    @Test
    void keepsRequestsIndependentAcrossDocuments() throws Exception {
        IFile file1 = TestUtils.createUniqueTestFile(this.project, "txt", "one");
        IFile file2 = TestUtils.createUniqueTestFile(this.project, "txt", "two");
        ITextViewer viewer1 = TestUtils.openTextViewer(file1);
        ITextViewer viewer2 = TestUtils.openTextViewer(file2);
        StubProvider provider = new StubProvider();
        CompletableFuture first = provider.provideCodeMinings(viewer1, (IProgressMonitor)new NullProgressMonitor());
        CompletableFuture second = provider.provideCodeMinings(viewer2, (IProgressMonitor)new NullProgressMonitor());
        Assertions.assertNotNull((Object)first);
        Assertions.assertNotNull((Object)second);
        Assertions.assertFalse((boolean)first.isCancelled(), (String)"request for doc1 must remain active when doc2 starts");
        Assertions.assertFalse((boolean)second.isCancelled(), (String)"request for doc2 must start active");
    }

    private static final class StubProvider
    extends AbstractLSPCodeMiningProvider {
        private StubProvider() {
        }

        protected @Nullable CompletableFuture<List<? extends ICodeMining>> doProvideCodeMinings(IDocument doc, TextDocumentIdentifier docId) {
            return new CompletableFuture<List<? extends ICodeMining>>();
        }
    }
}

