/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.rename;

import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.internal.NullSafetyHelper;
import org.eclipse.lsp4e.operations.rename.LSPFileOperationParticipantSupport;
import org.eclipse.lsp4j.CreateFilesParams;
import org.eclipse.lsp4j.FileCreate;
import org.eclipse.lsp4j.FileOperationsServerCapabilities;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.CreateParticipant;

public class LSPCreateParticipant
extends CreateParticipant {
    private URI newURI = (URI)NullSafetyHelper.lateNonNull();
    private IResource resource = (IResource)NullSafetyHelper.lateNonNull();

    public String getName() {
        return "LSP4E Create";
    }

    protected boolean initialize(Object element) {
        IResource res;
        if (element instanceof IResource && ((res = (IResource)element) instanceof IFile || res instanceof IFolder)) {
            this.resource = res;
            URI uri = LSPEclipseUtils.toUri(res);
            if (uri == null) {
                return false;
            }
            this.newURI = uri;
            return LSPFileOperationParticipantSupport.createFileOperationExecutor(res, FileOperationsServerCapabilities::getWillCreate).anyMatching();
        }
        return false;
    }

    public RefactoringStatus checkConditions(IProgressMonitor monitor, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public @Nullable Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        return null;
    }

    public @Nullable Change createPreChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        CreateFilesParams params = new CreateFilesParams();
        params.getFiles().add(new FileCreate(this.newURI.toString()));
        return LSPFileOperationParticipantSupport.computePreChange(this.getName(), params, this.resource, FileOperationsServerCapabilities::getWillCreate, (ws, p) -> ws.willCreateFiles(p));
    }
}

