/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.kura.audit.AuditContext;
import org.eclipse.kura.web.Console;
import org.eclipse.kura.web.UserManager;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.session.Attributes;
import org.eclipse.kura.web.shared.GwtKuraErrorCode;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtConsoleUserOptions;
import org.eclipse.kura.web.shared.model.GwtUserConfig;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtSessionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwtSessionServiceImpl
extends OsgiRemoteServiceServlet
implements GwtSessionService {
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"AuditLogger");
    private final UserManager userManager;
    private static final long serialVersionUID = 1L;

    public GwtSessionServiceImpl(UserManager userManager) {
        this.userManager = userManager;
    }

    @Override
    public void logout(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        HttpServletRequest request = this.getThreadLocalRequest();
        HttpServletResponse response = this.getThreadLocalResponse();
        HttpSession session = request.getSession(false);
        if (session != null) {
            Cookie[] cookies;
            Object username = session.getAttribute(Attributes.AUTORIZED_USER.getValue());
            session.invalidate();
            auditLogger.info("{} UI Session - Success - Logout succeeded for user: {}", (Object)AuditContext.currentOrInternal(), username);
            Cookie[] cookieArray = cookies = request.getCookies();
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                cookie.setMaxAge(0);
                cookie.setValue(null);
                cookie.setPath("/");
                response.addCookie(cookie);
                ++n2;
            }
        }
    }

    @Override
    public GwtConsoleUserOptions getUserOptions(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        return Console.getConsoleOptions().getUserOptions();
    }

    @Override
    public GwtUserConfig getUserConfig(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        HttpServletRequest request = this.getThreadLocalRequest();
        HttpSession session = request.getSession(false);
        if (session == null) {
            throw new GwtKuraException(GwtKuraErrorCode.UNAUTHENTICATED);
        }
        Object username = session.getAttribute(Attributes.AUTORIZED_USER.getValue());
        if (!(username instanceof String)) {
            throw new GwtKuraException(GwtKuraErrorCode.UNAUTHENTICATED);
        }
        try {
            return this.userManager.getUserConfig((String)username).orElse(null);
        }
        catch (GwtKuraException gwtKuraException) {
            auditLogger.warn("{} UI Session - Failure - Failed to get configuration for user {}", (Object)AuditContext.currentOrInternal(), username);
            return null;
        }
    }

    @Override
    public void updatePassword(GwtXSRFToken xsrfToken, String oldPassword, String newPassword) throws GwtKuraException {
        Optional<GwtUserConfig> userConfig;
        this.checkXSRFToken(xsrfToken);
        HttpServletRequest request = this.getThreadLocalRequest();
        HttpSession session = request.getSession(false);
        String username = this.getSessionUsername(session);
        try {
            userConfig = this.userManager.getUserConfig(username);
        }
        catch (GwtKuraException gwtKuraException) {
            throw new GwtKuraException(GwtKuraErrorCode.OPERATION_NOT_SUPPORTED);
        }
        if (!userConfig.isPresent() || !userConfig.get().isPasswordAuthEnabled()) {
            throw new GwtKuraException(GwtKuraErrorCode.OPERATION_NOT_SUPPORTED);
        }
        try {
            this.userManager.authenticateWithPassword(username, oldPassword);
        }
        catch (GwtKuraException gwtKuraException) {
            auditLogger.warn("{} UI Session - Failure - Wrong password for user {}", (Object)AuditContext.currentOrInternal(), (Object)username);
            throw new GwtKuraException(GwtKuraErrorCode.INVALID_USERNAME_PASSWORD);
        }
        if (Objects.equals(oldPassword, newPassword)) {
            throw new GwtKuraException(GwtKuraErrorCode.PASSWORD_CHANGE_SAME_PASSWORD);
        }
        try {
            this.userManager.setUserPassword(username, newPassword);
            auditLogger.info("{} UI Session - Success - Password updated for user {}", (Object)AuditContext.currentOrInternal(), (Object)username);
        }
        catch (GwtKuraException gwtKuraException) {
            auditLogger.warn("{} UI Session - Failure - Failed to update password for user {}", (Object)AuditContext.currentOrInternal(), (Object)username);
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR);
        }
        HttpSession newSession = Console.instance().createNewSession(request);
        this.setAuthenticated(newSession, username);
    }

    private String getSessionUsername(HttpSession session) throws GwtKuraException {
        if (session == null) {
            throw new GwtKuraException(GwtKuraErrorCode.UNAUTHENTICATED);
        }
        Object username = session.getAttribute(Attributes.AUTORIZED_USER.getValue());
        if (!(username instanceof String)) {
            throw new GwtKuraException(GwtKuraErrorCode.UNAUTHENTICATED);
        }
        return (String)username;
    }

    private void setAuthenticated(HttpSession session, String username) throws GwtKuraException {
        Console.instance().setAuthenticated(session, username, (AuditContext)AuditContext.current().orElseThrow(() -> new GwtKuraException("Audit context is not available")));
        session.removeAttribute(Attributes.LOCKED.getValue());
    }
}

