/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.constraintdefinition.serviceloading;

import jakarta.validation.ValidationException;
import jakarta.validation.Validator;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintdefinition.serviceloading.BuiltInOrderBean;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintdefinition.serviceloading.OrderAnnotationBean;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintdefinition.serviceloading.OrderXmlBean;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintdefinition.serviceloading.OrderXmlOverrideBean;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintdefinition.serviceloading.OrderXmlOverrideConstraint;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.IntegrationTest;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@IntegrationTest
@SpecVersion(spec="beanvalidation", version="4.0.0")
public class ServiceLoadedConstraintOrderTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)ServiceLoadedConstraintOrderTest.webArchiveBuilder().withTestClassPackage(ServiceLoadedConstraintOrderTest.class)).withValidationXml("loader-validation.xml")).withResource("constraints-definition.xml", "META-INF/constraints-definition.xml", true)).withResource("jakarta.validation.ConstraintValidator-order", "META-INF/services/jakarta.validation.ConstraintValidator", true)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-register-validators", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-register-validators", id="d")})
    public void testConstraintValidatorLoadedOrderBuiltInConstraint() {
        Assertions.assertThatThrownBy(() -> {
            Validator validator = TestUtil.getValidatorUnderTest();
            validator.validate((Object)new BuiltInOrderBean(), new Class[0]);
        }).isInstanceOf(ValidationException.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-register-validators", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-register-validators", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-register-validators", id="d")})
    public void testConstraintValidatorLoadedOrderAnnotation() {
        Assertions.assertThatThrownBy(() -> {
            Validator validator = TestUtil.getValidatorUnderTest();
            validator.validate((Object)new OrderAnnotationBean("foo"), new Class[0]);
        }).isInstanceOf(ValidationException.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-register-validators", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-register-validators", id="c"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-register-validators", id="d")})
    public void testConstraintValidatorLoadedOrderXml() {
        Assertions.assertThatThrownBy(() -> {
            Validator validator = TestUtil.getValidatorUnderTest();
            validator.validate((Object)new OrderXmlBean("foo"), new Class[0]);
        }).isInstanceOf(ValidationException.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-register-validators", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-register-validators", id="c"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-register-validators", id="e")})
    public void testConstraintValidatorLoadedOrderXmlOverride() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validate((Object)new OrderXmlOverrideBean("foo"), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(OrderXmlOverrideConstraint.class));
        constraintViolations = validator.validate((Object)new OrderXmlOverrideBean("bar"), new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }
}

