/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.valueextraction.builtin;

import jakarta.validation.Validator;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="4.0.0")
public class ListValueExtractorTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)ListValueExtractorTest.webArchiveBuilder().withTestClass(ListValueExtractorTest.class)).build();
    }

    @Test
    @SpecAssertion(section="valueextractordefinition-builtinvalueextractors", id="b")
    public void listValueExtractor() {
        Validator validator = this.getValidator();
        Set violations = validator.validate((Object)new ListHolder(Arrays.asList("valid", null)), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("list").containerElement("<list element>", true, null, 1, List.class, 0));
    }

    private static class ListHolder {
        private final List<@NotNull String> list;

        private ListHolder(List<String> list) {
            this.list = list;
        }
    }
}

