/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.integration.ee;

import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.constraints.NotNull;
import java.util.Set;
import javax.naming.InitialContext;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.integration.ee.ConstantMessageInterpolator;
import org.hibernate.beanvalidation.tck.tests.integration.ee.Foo;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.IntegrationTest;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@IntegrationTest
@SpecVersion(spec="beanvalidation", version="4.0.0")
public class JndiRetrievalTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)JndiRetrievalTest.webArchiveBuilder().withTestClass(JndiRetrievalTest.class)).withClass(ConstantMessageInterpolator.class)).withClass(Foo.class)).withValidationXml("test-validation.xml")).withBeansXml().build();
    }

    @Test
    @SpecAssertion(section="integration-jakartaee", id="a")
    private void testDefaultValidatorFactoryCanBeRetrievedFromJndi() throws Exception {
        ValidatorFactory validatorFactory = (ValidatorFactory)InitialContext.doLookup("java:comp/ValidatorFactory");
        Assert.assertNotNull((Object)validatorFactory, (String)"Default validator factory should be bound to JNDI tree.");
        Assert.assertTrue((boolean)(validatorFactory.getMessageInterpolator() instanceof ConstantMessageInterpolator), (String)"Default validator factory bound to JNDI should be configured based on META-INF/validation.xml.");
        Set violations = validatorFactory.getValidator().validate((Object)new Foo(), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withMessage("Invalid constraint"));
    }

    @Test
    @SpecAssertion(section="integration-jakartaee", id="a")
    private void testDefaultValidatorCanBeRetrievedFromJndi() throws Exception {
        Validator validator = (Validator)InitialContext.doLookup("java:comp/Validator");
        Assert.assertNotNull((Object)validator, (String)"Default validator should be bound to JNDI tree.");
        Set violations = validator.validate((Object)new Foo(), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withMessage("Invalid constraint"));
    }
}

