/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.sampledb;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.birt.core.plugin.BIRTPlugin;
import org.eclipse.birt.report.data.oda.jdbc.IConnectionFactory;
import org.eclipse.birt.report.data.oda.jdbc.JDBCDriverManager;
import org.eclipse.birt.report.data.oda.sampledb.SampleDBJDBCConnectionFactory;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.services.PluginResourceLocator;
import org.osgi.framework.BundleContext;

public class SampledbPlugin
extends BIRTPlugin {
    private static final Logger logger = Logger.getLogger(SampledbPlugin.class.getName());
    private static String dbDir;
    private static final String SAMPLE_DB_NAME = "BirtSample";
    private static final String SAMPLE_DB_JAR_FILE = "BirtSample.jar";
    private static final String SAMPLE_DB_HOME_DIR = "db";
    private static int startCount;

    static {
        startCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        logger.info("Sampledb plugin starts up. Current startCount=" + startCount);
        Class<SampledbPlugin> clazz = SampledbPlugin.class;
        synchronized (SampledbPlugin.class) {
            if (++startCount == 1) {
                this.init();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            super.start(context);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        logger.info("Sampledb plugin stopping. Current startCount=" + startCount);
        Class<SampledbPlugin> clazz = SampledbPlugin.class;
        synchronized (SampledbPlugin.class) {
            if (startCount >= 1 && --startCount == 0) {
                this.cleanUp();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            super.stop(context);
            return;
        }
    }

    private void cleanUp() throws Exception {
        this.shutdownDerby();
        this.removeDatabase();
        dbDir = null;
    }

    private void init() throws IOException {
        ZipEntry entry;
        assert (dbDir == null);
        String tempDir = System.getProperty("java.io.tmpdir");
        String timeStamp = String.valueOf(System.currentTimeMillis());
        String instanceId = Integer.toHexString(((Object)((Object)this)).hashCode());
        dbDir = tempDir + "/BIRTSampleDB_" + timeStamp + "_" + instanceId;
        logger.info("Creating Sampledb database at location " + dbDir);
        new File(dbDir).mkdir();
        String dbEntryName = "db/BirtSample.jar";
        URL fileURL = PluginResourceLocator.getPluginEntry((String)"org.eclipse.birt.report.data.oda.sampledb", (String)dbEntryName);
        if (fileURL == null) {
            String errMsg = "INTERNAL ERROR: SampleDB DB file not found: " + dbEntryName;
            logger.severe(errMsg);
            throw new RuntimeException(errMsg);
        }
        BufferedInputStream dbFileStream = new BufferedInputStream(fileURL.openStream());
        ZipInputStream zipStream = new ZipInputStream(dbFileStream);
        while ((entry = zipStream.getNextEntry()) != null) {
            int len;
            File entryFile = new File(dbDir, entry.getName());
            if (entry.isDirectory()) {
                entryFile.mkdir();
                continue;
            }
            entryFile.getParentFile().mkdirs();
            FileOutputStream os = new FileOutputStream(entryFile);
            byte[] buf = new byte[4000];
            while ((len = zipStream.read(buf)) > 0) {
                ((OutputStream)os).write(buf, 0, len);
            }
            ((OutputStream)os).close();
        }
        zipStream.close();
        ((InputStream)dbFileStream).close();
    }

    public static String getDBUrl() {
        if (dbDir == null) {
            return "jdbc:derby:classpath:BirtSample";
        }
        return "jdbc:derby:" + dbDir + "/BirtSample";
    }

    private void shutdownDerby() {
        IConnectionFactory cf = null;
        try {
            cf = JDBCDriverManager.getInstance().getDriverConnectionFactory("org.eclipse.birt.report.data.oda.sampledb.Driver");
        }
        catch (OdaException odaException) {
            // empty catch block
        }
        if (cf != null) {
            ((SampleDBJDBCConnectionFactory)cf).shutdownDerby();
        }
    }

    private void removeDatabase() {
        logger.info("Removing Sampledb DB directory at location " + dbDir);
        File dbDirFile = new File(dbDir);
        if (!SampledbPlugin.removeDirectory(dbDirFile)) {
            assert (dbDirFile != null);
            dbDirFile.deleteOnExit();
            logger.info("Fail to remove one or more file in temp db directory,but it will be removed when the VM exits: " + dbDir);
        }
    }

    static boolean removeDirectory(File dir) {
        assert (dir != null && dir.isDirectory());
        boolean success = true;
        String[] children = dir.list();
        int i = 0;
        while (i < children.length) {
            File child = new File(dir, children[i]);
            if (child.isDirectory()) {
                if (!SampledbPlugin.removeDirectory(child)) {
                    success = false;
                }
            } else if (!child.delete()) {
                logger.info("Failed to delete temp file " + child.getAbsolutePath());
                success = false;
            }
            ++i;
        }
        if (!dir.delete()) {
            success = false;
        }
        return success;
    }
}

