/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.birt.report.designer.ui.cubebuilder.BuilderPlugin;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.UserPropertyDefnHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.UserPropertyException;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.HierarchyHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public final class UIHelper {
    public static URL getURL(String sPluginRelativePath) {
        URL url = null;
        if (Platform.getExtensionRegistry() != null) {
            try {
                url = new URL(BuilderPlugin.getDefault().getBundle().getEntry("/"), sPluginRelativePath);
            }
            catch (MalformedURLException e) {
                ExceptionUtil.handle((Throwable)e);
            }
        } else {
            try {
                url = new URL("file:///" + new File(sPluginRelativePath).getAbsolutePath());
            }
            catch (MalformedURLException e) {
                ExceptionUtil.handle((Throwable)e);
            }
        }
        return url;
    }

    private static Image createImage(String sPluginRelativePath) {
        Image img = null;
        try {
            try {
                img = new Image((Device)Display.getCurrent(), UIHelper.getURL(sPluginRelativePath).openStream());
            }
            catch (MalformedURLException e1) {
                img = new Image((Device)Display.getCurrent(), (InputStream)new FileInputStream(UIHelper.getURL(sPluginRelativePath).toString()));
            }
        }
        catch (IOException e) {
            ExceptionUtil.handle((Throwable)e);
        }
        if (img == null) {
            img = new Image((Device)Display.getCurrent(), 1, 1);
        }
        return img;
    }

    public static Image getImage(String sPluginRelativePath) {
        ImageRegistry registry = JFaceResources.getImageRegistry();
        Image image = registry.get(sPluginRelativePath);
        if (image == null) {
            image = UIHelper.createImage(sPluginRelativePath);
            registry.put(sPluginRelativePath, image);
        }
        return image;
    }

    public static boolean existIntProperty(ModuleHandle module, String id, String key) {
        UserPropertyDefnHandle property = module.getUserPropertyDefnHandle(id + "." + key);
        if (property == null) {
            return false;
        }
        return property.getType() == 2;
    }

    public static int getIntProperty(ModuleHandle module, String id, String key) {
        return module.getIntProperty(id + "." + key);
    }

    public static void createIntPropertyDefn(ModuleHandle module, String id, String key) throws UserPropertyException {
        UserPropertyDefnHandle property = module.getUserPropertyDefnHandle(id + "." + key);
        if (property != null && property.getType() != 2) {
            module.dropUserPropertyDefn(property.getName());
        }
        UserPropertyDefn propertyDefn = new UserPropertyDefn();
        propertyDefn.setName(id + "." + key);
        propertyDefn.setType(DEUtil.getMetaDataDictionary().getPropertyType(2));
        propertyDefn.setVisible(false);
        module.addUserPropertyDefn(propertyDefn);
    }

    public static void setIntProperty(ModuleHandle module, String id, String key, int value) throws SemanticException {
        if (!UIHelper.existIntProperty(module, id, key)) {
            UIHelper.createIntPropertyDefn(module, id, key);
        }
        module.setIntProperty(id + "." + key, value);
    }

    public static String getId(Object model, TabularCubeHandle carrier) {
        if (model instanceof DataSetHandle) {
            return carrier.getName() + "." + ((DesignElementHandle)model).getName();
        }
        if (model instanceof HierarchyHandle) {
            return carrier.getName() + "." + ((HierarchyHandle)model).getContainer().getName() + "." + ((DesignElementHandle)model).getName();
        }
        return "";
    }

    public static void dropDimensionProperties(DimensionHandle dimension) {
        TabularCubeHandle cube = (TabularCubeHandle)dimension.getContainer();
        HierarchyHandle hierarcy = dimension.getDefaultHierarchy();
        if (hierarcy == null) {
            return;
        }
        try {
            UIHelper.dropProperty(cube, hierarcy, "x");
            UIHelper.dropProperty(cube, hierarcy, "y");
            UIHelper.dropProperty(cube, hierarcy, "width");
            UIHelper.dropProperty(cube, hierarcy, "height");
        }
        catch (Exception e) {
            ExceptionUtil.handle((Throwable)e);
        }
    }

    private static void dropProperty(TabularCubeHandle cube, HierarchyHandle hierarcy, String type) throws Exception {
        ModuleHandle module = cube.getRoot();
        if (UIHelper.existIntProperty(hierarcy.getRoot(), UIHelper.getId(hierarcy, cube), type)) {
            if (module.getProperty(UIHelper.getId(hierarcy, cube) + "." + type) != null) {
                module.clearProperty(UIHelper.getId(hierarcy, cube) + "." + type);
            }
            module.dropUserPropertyDefn(UIHelper.getId(hierarcy, cube) + "." + type);
        }
    }
}

