/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.script.model;

import org.eclipse.birt.report.debug.internal.core.vm.VMValue;
import org.eclipse.birt.report.debug.internal.core.vm.VMVariable;
import org.eclipse.birt.report.debug.internal.script.model.ScriptDebugElement;
import org.eclipse.birt.report.debug.internal.script.model.ScriptDebugTarget;
import org.eclipse.birt.report.debug.internal.script.model.ScriptStackFrame;
import org.eclipse.birt.report.debug.internal.script.model.ScriptVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;

public class ScriptValue
extends ScriptDebugElement
implements IValue {
    private VMValue value;
    private ScriptStackFrame frame;

    public ScriptValue(ScriptStackFrame frame, VMValue value) {
        super((ScriptDebugTarget)frame.getDebugTarget());
        this.value = value;
        this.frame = frame;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.value.getTypeName();
    }

    public String getValueString() throws DebugException {
        return this.value.getValueString();
    }

    public IVariable[] getVariables() throws DebugException {
        VMVariable[] variables = this.value.getMembers();
        IVariable[] retValue = new IVariable[variables.length];
        int i = 0;
        while (i < variables.length) {
            VMVariable variable = variables[i];
            ScriptVariable debugVariable = new ScriptVariable(this.frame, variable.getName(), variable.getTypeName());
            VMValue value = variable.getValue();
            ScriptValue debugValue = new ScriptValue(this.frame, value);
            debugVariable.setOriVale(debugValue);
            retValue[i] = debugVariable;
            ++i;
        }
        return retValue;
    }

    public boolean hasVariables() throws DebugException {
        return this.getVariables().length > 0;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    @Override
    public String getDisplayName() {
        try {
            return this.getValueString();
        }
        catch (DebugException e) {
            return "";
        }
    }
}

