/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.core.mediator.IMediatorRequest;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.data.ui.dataset.AdvancedDataSetEditor;
import org.eclipse.birt.report.designer.data.ui.dataset.JointDataSetWizard;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseWizardDialog;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class NewJointDataSetAction
extends Action {
    public static final String ID = "org.eclipse.birt.report.designer.ui.actions.NewJointDataSetAction";
    private DataSetHandle dataSetHandle;

    public NewJointDataSetAction() {
        this.setId(ID);
    }

    public NewJointDataSetAction(String text) {
        super(text);
        this.setId(ID);
    }

    public NewJointDataSetAction(String text, int style) {
        super(text, style);
        this.setId(ID);
    }

    public NewJointDataSetAction(String text, ImageDescriptor image) {
        super(text, image);
        this.setId(ID);
    }

    public void run() {
        if (Policy.TRACING_ACTIONS) {
            System.out.println("New joint data set action >> Run ...");
        }
        if (SessionHandleAdapter.getInstance().getReportDesignHandle() == null) {
            return;
        }
        List existingDataSets = this.getDataSets();
        if (existingDataSets.isEmpty()) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"JointDataSetPage.error.nodataset.title"), (String)Messages.getString((String)"JointDataSetPage.error.nodataset.title"));
            this.notifyResult(false);
        } else {
            if (SessionHandleAdapter.getInstance().getReportDesignHandle() == null) {
                return;
            }
            HandleAdapterFactory.getInstance().getReportDesignHandleAdapter().getModuleHandle().getCommandStack().startPersistentTrans(Messages.getString((String)"dataset.join.new"));
            JointDataSetWizard wizard = new JointDataSetWizard();
            wizard.setWindowTitle(Messages.getString((String)"dataset.join.new"));
            BaseWizardDialog dialog = new BaseWizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)wizard){

                protected void configureShell(Shell newShell) {
                    super.configureShell(newShell);
                    newShell.setSize(750, 650);
                    Rectangle rect = Display.getDefault().getBounds();
                    newShell.setLocation((rect.width - 750) / 2, (rect.height - 650) / 2);
                }
            };
            if (dialog.open() == 0) {
                List newDataSets = this.getDataSets();
                this.editDataSet(existingDataSets, newDataSets);
                HandleAdapterFactory.getInstance().getReportDesignHandleAdapter().getModuleHandle().getCommandStack().commit();
                ReportRequest request = new ReportRequest("create element");
                ArrayList<DataSetHandle> selectionObjects = new ArrayList<DataSetHandle>();
                selectionObjects.add(this.dataSetHandle);
                request.setSelectionObject(selectionObjects);
                SessionHandleAdapter.getInstance().getMediator().notifyRequest((IMediatorRequest)request);
                this.notifyResult(true);
            } else {
                HandleAdapterFactory.getInstance().getReportDesignHandleAdapter().getModuleHandle().getCommandStack().rollback();
                this.notifyResult(false);
            }
        }
    }

    private List getDataSets() {
        List dataSets = HandleAdapterFactory.getInstance().getReportDesignHandleAdapter().getModuleHandle().getVisibleDataSets();
        return dataSets;
    }

    private boolean editDataSet(List existingDataSets, List newDataSets) {
        if (existingDataSets == null || newDataSets == null || newDataSets.size() <= existingDataSets.size()) {
            return false;
        }
        this.dataSetHandle = this.findNewDataSet(existingDataSets, newDataSets);
        if (this.dataSetHandle == null) {
            return false;
        }
        if (this.dataSetHandle instanceof ScriptDataSetHandle) {
            return false;
        }
        AdvancedDataSetEditor dialog = new AdvancedDataSetEditor(PlatformUI.getWorkbench().getDisplay().getActiveShell(), this.dataSetHandle, false, true);
        return dialog.open() == 0;
    }

    private DataSetHandle findNewDataSet(List existingDataSets, List newDataSets) {
        int i = 0;
        while (i < newDataSets.size()) {
            if (!existingDataSets.contains(newDataSets.get(i))) {
                return (DataSetHandle)newDataSets.get(i);
            }
            ++i;
        }
        return null;
    }
}

