/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.util;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.dom.StyleDeclaration;
import org.eclipse.birt.report.engine.css.engine.BIRTCSSEngine;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.css.engine.value.URIValue;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.layout.pdf.util.ShortHandProcessor;
import org.eclipse.birt.report.engine.layout.pdf.util.StyleProperties;
import org.eclipse.birt.report.engine.util.FileUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSValue;

public class HTMLStyleProcessor {
    private static Logger logger = Logger.getLogger(HTMLStyleProcessor.class.getName());
    private ReportDesignHandle report;
    private CSSEngine cssEngine = new BIRTCSSEngine();
    private static Pattern pattern = Pattern.compile("[\\s|\t|\r|\n]*([^:]*)[ ]*:[ ]*([^;]*)[ ]*[;]*");
    private static String LIST_STYLE_TYPE = "list-style-type";

    public HTMLStyleProcessor(ReportDesignHandle report) {
        this.report = report;
    }

    protected void processBackgroundImage(IStyle style, Map context) {
        String bgi;
        CSSValue value;
        if (style != null && (value = style.getProperty(56)) instanceof URIValue && (bgi = ((URIValue)value).getStringValue()) != null && !"".equals(bgi)) {
            String fileName;
            URL url;
            if (this.report != null && FileUtil.isLocalResource(bgi) && (url = this.report.findResource(bgi, 1, context)) != null && (fileName = url.getFile()) != null) {
                bgi = fileName;
            }
            style.setBackgroundImage(bgi);
        }
    }

    protected StyleProperties getStyleProperties(Element ele, HashMap<Element, StyleProperties> styles) {
        StyleProperties sp = styles.get(ele);
        if (sp == null) {
            sp = new StyleProperties(new StyleDeclaration(this.cssEngine));
            styles.put(ele, sp);
        }
        return sp;
    }

    public void execute(Element ele, HashMap<Element, StyleProperties> styles, Map context) {
        StringBuffer strStyle = new StringBuffer();
        StyleProperties sp = this.getStyleProperties(ele, styles);
        try {
            String inlineStyle = ele.getAttribute("style");
            if (inlineStyle != null && !"".equals(inlineStyle)) {
                StringBuffer buffer = new StringBuffer();
                Matcher matcher = pattern.matcher(inlineStyle);
                while (matcher.find()) {
                    DimensionType d;
                    String name = matcher.group(1);
                    String value = matcher.group(2);
                    if (name != null && name.length() > 0 && value != null && value.length() > 0) {
                        ShortHandProcessor.process(buffer, name, value, this.cssEngine);
                    }
                    if ("width".equals(name) && value != null && value.length() > 0 && (d = DimensionType.parserUnit(value)) != null) {
                        sp.addProperty("width", d);
                    }
                    if ("height".equals(name) && value != null && value.length() > 0 && (d = DimensionType.parserUnit(value)) != null) {
                        sp.addProperty("height", d);
                    }
                    if (LIST_STYLE_TYPE.equals(name) && value != null && value.length() > 0) {
                        sp.addProperty(LIST_STYLE_TYPE, value);
                    }
                    if (!"text-decoration".equals(name) || value == null || value.length() <= 0) continue;
                    IStyle style = sp.getStyle();
                    String[] vs = value.split(" ");
                    int i = 0;
                    while (i < vs.length) {
                        if ("underline".equals(vs[i])) {
                            style.setTextUnderline("underline");
                        } else if ("line-through".equals(vs[i])) {
                            style.setTextLineThrough("line-through");
                        } else if ("overline".equals(vs[i])) {
                            style.setTextOverline("overline");
                        }
                        ++i;
                    }
                }
                strStyle.append(buffer.toString());
            }
            if (strStyle.length() > 0) {
                sp.getStyle().setProperties((StyleDeclaration)this.cssEngine.parseStyleDeclaration(strStyle.toString().toLowerCase()));
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "The css statement is:" + ele.getAttribute("style"), e);
        }
        ele.removeAttribute("style");
        this.processBackgroundImage(sp.getStyle(), context);
        int i = 0;
        while (i < ele.getChildNodes().getLength()) {
            Node child = ele.getChildNodes().item(i);
            if (child.getNodeType() == 1) {
                this.execute((Element)child, styles, context);
            }
            ++i;
        }
    }
}

