# 2022-02-24 Triage Log

A relatively quiet week with improvements largely outweighing regressions. On the regressions side, doc performance has worsened somewhat significantly most likely introduced by adding more docs to blanket impls. On the improvement side, LLVM 14 allowed for an optimization the significantly improves codegen performance.

Triage done by **@rylev**.
Revision range: [a240ccd81c74c105b6f5fe84c46f8d36edb7e306..1204400ab8da9830f6f77a5e40e7ad3ea459676a](https://perf.rust-lang.org/?start=a240ccd81c74c105b6f5fe84c46f8d36edb7e306&end=1204400ab8da9830f6f77a5e40e7ad3ea459676a&absolute=false&stat=instructions%3Au)

3 Regressions, 2 Improvements, 7 Mixed; 3 of them in rollups
38 comparisons made in total

#### Regressions

Rollup of 8 pull requests [#94072](https://github.com/rust-lang/rust/issues/94072)
- Average relevant regression: 11.3%
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=930fc4f59ddeb9f26d554a2c75c5355989189540&end=582b6964a8868c9714881d9821d08415a8f4f13b&stat=instructions:u): 157.0% on `full` builds of `stm32f4 doc`
- The regressions are all in doc runs but the largest are quite severe.
- The most likely culprit is [#89869](https://github.com/rust-lang/rust/pull/89869) which adds documentation to many different blanket impls.
- Left a comment to [investigate](https://github.com/rust-lang/rust/pull/94072#issuecomment-1049807469).


Rollup of 9 pull requests [#94103](https://github.com/rust-lang/rust/issues/94103)
- Average relevant regression: 1.1%
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=30b3f35c420694a4f24e5a4df00f06073f4f3a37&end=73a7423e77b49a99e270531fbadda5b8899df3f6&stat=instructions:u): 2.1% on `full` builds of `deeply-nested-async check`
- Almost all of the regressions are in stress tests so the actual impact on users is likely not that large
- None of the rolled up PRs seem to be suspicious so it's hard to know where to begin


Fix a layout possible miscalculation in `alloc::RawVec` [#83706](https://github.com/rust-lang/rust/issues/83706)
- Average relevant regression: 0.5%
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=68369a041cea809a87e5bd80701da90e0e0a4799&end=5bd1ec3283874b97b27da4539b2950fbd01c4b0e&stat=instructions:u): 1.2% on `incr-unchanged` builds of `deeply-nested-async debug`
- A small regression would seem likely after this change since more work (e.g., checked multiplication) is being done in RawVec which is used quite a lot. I am, however, unsure whether the actual regression we're seeing here is expected
- Left a comment for [investigation](https://github.com/rust-lang/rust/pull/83706#issuecomment-1049820205).


#### Improvements

Rollup of 7 pull requests [#94254](https://github.com/rust-lang/rust/issues/94254)
- Average relevant improvement: -0.8%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=9ecd75b831f744b9bdfb5ec4d435fa20c65e074e&end=68369a041cea809a87e5bd80701da90e0e0a4799&stat=instructions:u): -0.8% on `incr-unchanged` builds of `externs opt`


Reapply cg_llvm: `fewer_names` in `uncached_llvm_type` [#94107](https://github.com/rust-lang/rust/issues/94107)
- Average relevant improvement: -7.8%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=8ebec97e09a89760e5791bbb2ab96e2ebec19931&end=e780264e1e5c1efa6ab76c7b17a9677f16add5e0&stat=instructions:u): -61.2% on `incr-patched: println` builds of `webrender-wrench opt`


#### Mixed

Upgrade to LLVM 14 [#93577](https://github.com/rust-lang/rust/issues/93577)
- Average relevant regression: 0.7%
- Average relevant improvement: -1.3%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=582b6964a8868c9714881d9821d08415a8f4f13b&end=30b3f35c420694a4f24e5a4df00f06073f4f3a37&stat=instructions:u): -3.8% on `full` builds of `projection-caching check`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=582b6964a8868c9714881d9821d08415a8f4f13b&end=30b3f35c420694a4f24e5a4df00f06073f4f3a37&stat=instructions:u): 3.0% on `incr-patched: add static arr item` builds of `coercions debug`
- Upgrading LLVM is always likely to produce performance changes. Luckily the perf improvements seem to outweigh the perf regressions considerably both in number and magnitude.


Revert #91403 [#94088](https://github.com/rust-lang/rust/issues/94088)
- Average relevant regression: 1.1%
- Average relevant improvement: -1.5%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=f838a425e3134d036a7d9632935111a569ac7446&end=feac2ecf1cae1dd0f56bed1cecc6e109c64b3d4f&stat=instructions:u): -1.7% on `full` builds of `issue-88862 check`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=f838a425e3134d036a7d9632935111a569ac7446&end=feac2ecf1cae1dd0f56bed1cecc6e109c64b3d4f&stat=instructions:u): 1.7% on `incr-unchanged` builds of `clap-rs check`
- The perf regressions here are relatively minor, and this change fixes a correctness issue, so I think it's fine to let it through.


Guard against unwinding in cleanup code [#92911](https://github.com/rust-lang/rust/issues/92911)
- Average relevant regression: 0.9%
- Average relevant improvement: -1.6%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=3b348d932aa5c9884310d025cf7c516023fd0d9a&end=26904687275a55864f32f3a7ba87b7711d063fd5&stat=instructions:u): -3.4% on `incr-full` builds of `syn opt`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=3b348d932aa5c9884310d025cf7c516023fd0d9a&end=26904687275a55864f32f3a7ba87b7711d063fd5&stat=instructions:u): 3.7% on `full` builds of `ripgrep opt`
- A relatively large regression considering the change is meant to protect against a rare occurrence (double unwind).
- Left a comment asking for [justification](https://github.com/rust-lang/rust/pull/92911#issuecomment-1049838729).


Allow inlining of `ensure_sufficient_stack()` [#93934](https://github.com/rust-lang/rust/issues/93934)
- Average relevant regression: 0.9%
- Average relevant improvement: -0.8%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=3b186511f62b0ce20e72ede0e8e13f8787155f02&end=c1aa85475cf5623caf50f7ef3b62903bb084e518&stat=instructions:u): -1.0% on `incr-patched: add vec item` builds of `deep-vector opt`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=3b186511f62b0ce20e72ede0e8e13f8787155f02&end=c1aa85475cf5623caf50f7ef3b62903bb084e518&stat=instructions:u): 0.9% on `incr-unchanged` builds of `ctfe-stress-4 check`
- This was an attempt at an optimization that proved fruitful before LLVM 14 was merged. [Now](https://github.com/rust-lang/rust/pull/93934#issuecomment-1048629651) the regressions and improvements weigh each other out.


safely `transmute<&List<Ty<'tcx>>, &List<GenericArg<'tcx>>>` [#93505](https://github.com/rust-lang/rust/issues/93505)
- Average relevant regression: 1.2%
- Average relevant improvement: -0.6%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=1103d2e914b67c18b0deb86073c26c6aefda761d&end=03a8cc7df1d65554a4d40825b0490c93ac0f0236&stat=instructions:u): -0.8% on `incr-full` builds of `ucd check`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=1103d2e914b67c18b0deb86073c26c6aefda761d&end=03a8cc7df1d65554a4d40825b0490c93ac0f0236&stat=instructions:u): 2.7% on `full` builds of `deeply-nested-async check`
- This led to a larger regression than was seen before the PR was merged. 
- The author is now [looking into the perf](https://github.com/rust-lang/rust/pull/93505#issuecomment-1047538798)


Simplify rustc_serialize by dropping support for decoding into JSON [#93839](https://github.com/rust-lang/rust/issues/93839)
- Average relevant regression: 0.8%
- Average relevant improvement: -0.5%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=b8967b0d52a2ba5f0c9da0da03e78ccba5534e4a&end=58a721af9f818bdf57f86448557b45c5ae19a3ef&stat=instructions:u): -0.5% on `incr-unchanged` builds of `ctfe-stress-4 check`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=b8967b0d52a2ba5f0c9da0da03e78ccba5534e4a&end=58a721af9f818bdf57f86448557b45c5ae19a3ef&stat=instructions:u): 1.0% on `full` builds of `externs opt`
- This change was [justified](https://github.com/rust-lang/rust/pull/93839#issuecomment-1035359841): The performance changes to the compiler are pretty much a wash, but this does have a good impact on compiler bootstrapping (~6 seconds).


Introduce `ChunkedBitSet` and use it for some dataflow analyses. [#93984](https://github.com/rust-lang/rust/issues/93984)
- Average relevant regression: 1.0%
- Average relevant improvement: -3.8%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=5bd1ec3283874b97b27da4539b2950fbd01c4b0e&end=bafe8d06e015eb00724d3d497516191d6681943f&stat=instructions:u): -5.3% on `full` builds of `keccak debug`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=5bd1ec3283874b97b27da4539b2950fbd01c4b0e&end=bafe8d06e015eb00724d3d497516191d6681943f&stat=instructions:u): 6.0% on `full` builds of `clap-rs check`
- While the regressions look minor they are likely even less of an issue due to this particular optimization likely helping wall-time and definitely helping max RSS while hurting instruction counts.
- For more detail see the [justification](https://github.com/rust-lang/rust/pull/93984#issuecomment-1043994374).


#### Untriaged Pull Requests

- [#94103 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/94103)
- [#94072 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/94072)
- [#93670 Apply noundef attribute to &T, &mut T, Box<T>, bool](https://github.com/rust-lang/rust/pull/93670)
- [#93505 safely `transmute<&List<Ty<'tcx>>, &List<GenericArg<'tcx>>>`](https://github.com/rust-lang/rust/pull/93505)
- [#93466 Make dead code check a query.](https://github.com/rust-lang/rust/pull/93466)
- [#93312 Return an indexmap in `all_local_trait_impls` query](https://github.com/rust-lang/rust/pull/93312)
- [#93298 make `find_similar_impl_candidates` even fuzzier](https://github.com/rust-lang/rust/pull/93298)
- [#93288 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/93288)
- [#93154 debuginfo: Make sure that type names for closure and generator environments are unique in debuginfo.](https://github.com/rust-lang/rust/pull/93154)
- [#93148 Overhaul interning.](https://github.com/rust-lang/rust/pull/93148)
- [#93138 Rollup of 17 pull requests](https://github.com/rust-lang/rust/pull/93138)
- [#93095 Store a `Symbol` instead of an `Ident` in `AssocItem`](https://github.com/rust-lang/rust/pull/93095)
- [#92911 Guard against unwinding in cleanup code](https://github.com/rust-lang/rust/pull/92911)
- [#92896 Update some rustc dependencies to deduplicate them](https://github.com/rust-lang/rust/pull/92896)
- [#92844 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/92844)
- [#92816 Remove deprecated LLVM-style inline assembly](https://github.com/rust-lang/rust/pull/92816)
- [#92805 partially revertish `lazily "compute" anon const default substs`](https://github.com/rust-lang/rust/pull/92805)
- [#92535 Allow unwinding from OOM hooks](https://github.com/rust-lang/rust/pull/92535)
- [#92534 Hash `Ident` spans in all HIR structures](https://github.com/rust-lang/rust/pull/92534)
- [#92356 Add {Add,Sub,Mul,Div,Rem,BitXor,BitOr,BitAnd}{,Assign}<$t> to Saturat…](https://github.com/rust-lang/rust/pull/92356)
- [#92277 rustc_metadata: Stop passing `CrateMetadataRef` by reference (step 1)](https://github.com/rust-lang/rust/pull/92277)
- [#92252 Update pulldown-cmark version to 0.9](https://github.com/rust-lang/rust/pull/92252)
- [#92229 Do not display `~const Drop` in rustdoc](https://github.com/rust-lang/rust/pull/92229)
- [#92227 Rustdoc: use `is_doc_hidden` method on more places](https://github.com/rust-lang/rust/pull/92227)
- [#92149 Fix bad caching of `~const Drop` bounds](https://github.com/rust-lang/rust/pull/92149)
- [#92135 Add `#[inline]` modifier to `TypeId::of`](https://github.com/rust-lang/rust/pull/92135)
- [#92110 Backport LLVM changes to disable deferred inlining](https://github.com/rust-lang/rust/pull/92110)

