% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label-bytes.R
\name{label_bytes}
\alias{label_bytes}
\title{Label bytes (1 kB, 2 MB, etc)}
\usage{
label_bytes(units = "auto_si", accuracy = 1, scale = 1, ...)
}
\arguments{
\item{units}{Unit to use. Should either one of:
\itemize{
\item "kB", "MB", "GB", "TB", "PB", "EB", "ZB", and "YB" for
SI units (base 1000).
\item "kiB", "MiB", "GiB", "TiB", "PiB", "EiB", "ZiB", and "YiB" for
binary units (base 1024).
\item \code{auto_si} or \code{auto_binary} to automatically pick the most appropriate
unit for each value.
}}

\item{accuracy}{A number to round to. Use (e.g.) \code{0.01} to show 2 decimal
places of precision. If \code{NULL}, the default, uses a heuristic that should
ensure breaks have the minimum number of digits needed to show the
difference between adjacent values.

Applied to rescaled data.}

\item{scale}{A scaling factor: \code{x} will be multiplied by \code{scale} before
formatting. This is useful if the underlying data is very small or very
large.}

\item{...}{
  Arguments passed on to \code{\link[=number]{number}}
  \describe{
    \item{\code{prefix}}{Additional text to display before the number. The suffix is
applied to absolute value before \code{style_positive} and \code{style_negative} are
processed so that \code{prefix = "$"} will yield (e.g.) \verb{-$1} and \verb{($1)}.}
    \item{\code{suffix}}{Additional text to display after the number.}
    \item{\code{big.mark}}{Character used between every 3 digits to separate thousands.}
    \item{\code{decimal.mark}}{The character to be used to indicate the numeric
decimal point.}
    \item{\code{style_positive}}{A string that determines the style of positive numbers:
\itemize{
\item \code{"none"} (the default): no change, e.g. \code{1}.
\item \code{"plus"}: preceded by \code{+}, e.g. \code{+1}.
\item \code{"space"}: preceded by a Unicode "figure space", i.e., a space equally
as wide as a number or \code{+}. Compared to \code{"none"}, adding a figure space
can ensure numbers remain properly aligned when they are left- or
right-justified.
}}
    \item{\code{style_negative}}{A string that determines the style of negative numbers:
\itemize{
\item \code{"hyphen"} (the default): preceded by a standard hypen \code{-}, e.g. \code{-1}.
\item \code{"minus"}, uses a proper Unicode minus symbol. This is a typographical
nicety that ensures \code{-} aligns with the horizontal bar of the
the horizontal bar of \code{+}.
\item \code{"parens"}, wrapped in parentheses, e.g. \code{(1)}.
}}
    \item{\code{scale_cut}}{Named numeric vector that allows you to rescale large
(or small) numbers and add a prefix. Built-in helpers include:
\itemize{
\item \code{cut_short_scale()}: [10^3, 10^6) = K, [10^6, 10^9) = M, [10^9, 10^12) = B, [10^12, Inf) = T.
\item \code{cut_long_scale()}: [10^3, 10^6) = K, [10^6, 10^12) = M, [10^12, 10^18) = B, [10^18, Inf) = T.
\item \code{cut_si(unit)}: uses standard SI units.
}

If you supply a vector \code{c(a = 100, b = 1000)}, absolute values in the
range \verb{[0, 100)} will not be rescaled, absolute values in the range \verb{[100, 1000)}
will be divided by 100 and given the suffix "a", and absolute values in
the range \verb{[1000, Inf)} will be divided by 1000 and given the suffix "b".
If the division creates an irrational value (or one with many digits), the
cut value below will be tried to see if it improves the look of the final
label.}
    \item{\code{trim}}{Logical, if \code{FALSE}, values are right-justified to a common
width (see \code{\link[base:format]{base::format()}}).}
  }}
}
\value{
A labeller function that takes a numeric vector of breaks and
returns a character vector of labels.
}
\description{
Scale bytes into human friendly units. Can use either SI units (e.g.
kB = 1000 bytes) or binary units (e.g. kiB = 1024 bytes). See
\href{https://en.wikipedia.org/wiki/Units_of_information}{Units of Information}
on Wikipedia for more details.
}
\examples{
demo_continuous(c(1, 1e6))
demo_continuous(c(1, 1e6), labels = label_bytes())

# Auto units are particularly nice on log scales
demo_log10(c(1, 1e7), labels = label_bytes())

# You can also set the units
demo_continuous(c(1, 1e6), labels = label_bytes("kB"))

# You can also use binary units where a megabyte is defined as
# (1024) ^ 2 bytes rather than (1000) ^ 2. You'll need to override
# the default breaks to make this more informative.
demo_continuous(c(1, 1024^2),
  breaks = breaks_width(250 * 1024),
  labels = label_bytes("auto_binary")
)
}
\seealso{
Other labels for continuous scales: 
\code{\link{label_currency}()},
\code{\link{label_number_auto}()},
\code{\link{label_number_si}()},
\code{\link{label_ordinal}()},
\code{\link{label_parse}()},
\code{\link{label_percent}()},
\code{\link{label_pvalue}()},
\code{\link{label_scientific}()}

Other labels for log scales: 
\code{\link{label_log}()},
\code{\link{label_number_si}()},
\code{\link{label_scientific}()}
}
\concept{labels for continuous scales}
\concept{labels for log scales}
