# Changes since [4.2.1](./4.2.1.md)

## Bug fixes

- Tabfile writer: fix replacing `\` with `\\`
- `--remove-html` flag: fix bad regex
- ui_cmd_interactive: fix a few bugs
- Lowercase word/entry links (`<a href="bword://...`) when `--lower` flag is passed
- `TextGlossaryWriter`: do not skip words that start with `#`
- Fix `StdLogHandler`: was not applying `--no-color`
- Fix checking for `sys.frozen`

## New features

- Add `auto_sqlite` [config parameter](../config.rst)

  - to use SQLite mode for StarDict and EPUB-2 (which require sorting) by default
  - also allow overriding it with `--no-sqlite` flag

- Add 3 config parameters allow changing log [colors](../term-colors.md) in terminal:

  - `color.cmd.critical`
  - `color.cmd.error`
  - `color.cmd.warning`

- Add 2 keys to config to enable/disable colors in Unix and Windows separately

  - `color.enable.cmd.unix`: default `true`
  - `color.enable.cmd.windows`: default `false`

## New features for library users

- Allow `glos.setInfo(key, None)` to delete the info / metadata key

- Add `glos.alts` property as shortcut, and use it internally

## Design improvements

Change `rawEntry[0]` from `bytes` to `List[str]` and avoid split/join when converting `rawEntry` \<-> `entry`.
This fixes some very edge cases involving `|` in words, but uses more RAM in indirect mode (converting to StarDict), which can be solved with `--sqlite`.

## Documentation

- Replace `doc/config.md` with [doc/config.rst](../config.rst), update comments and other improvements
- Generate [doc/entry-filters.md](../entry-filters.md)
- Update plugins doc
- Update README.md

## Unit testing

**Coverage of `glossary.py`: %75**

There are 2501 lines of test code in [tests](../../tests) directory.

Tests for Glossary class include:

- Basic functionality
- Error handling
- Sorting and direct / indirect / SQLite modes
- Entry filter config/flags (`lower`, `rtl`, `remove_html`, `remove_html_all`)
- Resources / data entries
- Convert: Tabfile \<-> Aard2 slob
- Convert: Tabfile \<-> CSV
- Convert: Tabfile  -> EPUB-2
- Convert: Tabfile  -> JSON
- Convert: Tabfile \<-> StarDict

Other improvements:

- `glossary_test.py`: check CRC32 of downloaded test files
- `glossary_test.py`: use a new temp dir for each test method for isolation.
- `ebook_kobo_test.py`: split into several test methods

## Improvements

- Zim: make improvements, [#352](https://github.com/ilius/pyglossary/issues/352)
- Aard2 slob: add 2 mime types, [#352](https://github.com/ilius/pyglossary/issues/352)
- ui/main.py: do not allow --remove-html and --remove-html-all together
- Glossary: do not allow `glos.config` to be set twice
- Glossary: change some error logs to critical, and more improvements
- Prevent conflicting config flags together, like `--lower --no-lower`
- Disable `utf8_check` config parameter by default (not needed since `3.0.0`)

## Refactoring and cleanup

- Glossary: some refactoring in convert method
- Rename 3 scripts in `scripts/` directory
- Remove `DataEntry.fromFile` and improve behavior of `DataEntry.__init__`
- Refactoring in ui/
- rename `option.cmdFlag` to `option.customFlag`
- Glossary: add `glos.rawEntryCompress` property, and use in `entry.py`
- Glossary: minor improvement in loadPlugins
- XDXF: remove useless argument in `Reader.open`
- remove unused some functions from `text_utils.py`
- `plugin_prop.py`: refactor getExtraOptions
- Avoid assigning protected attrs in `text_writer.py` and `plugins/tabfile.py`
- Fewer protected attr access in `entry_filters.py`
- Move `sortKey` and `get_prefix` implementations from `ebook_base.py` to epub and mobi plugins
- Change name of 2 entry filters to match the config param
