/**
* @license Apache-2.0
*
* Copyright (c) 2021 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#include "stdlib/ndarray/base/unary/internal/range.h"
#include <stdint.h>

/**
* Writes `n` evenly spaced values from `0` to `n-1` to an output array.
*
* @private
* @param n    number of values to write
* @param out  output array
*/
void stdlib_ndarray_base_unary_internal_range( const int64_t n, int64_t *out ) {
	int64_t i;
	for ( i = 0; i < n; i++ ) {
		out[ i ] = i;
	}
}
