# Contributing to IGV

First off, thanks for taking the time to contribute!

The following is a set of guidelines for contributing to IGV, which is hosted in the [igvteam repositories](https://github.com/igvteam/igv) on GitHub. These are mostly guidelines, not rules. Use your best judgment, and feel free to propose changes to this document in a pull request.

## Code of Conduct

This project and everyone participating in it is governed by the [Code of Conduct](CODE_OF_CONDUCT.md). By participating, you are expected to uphold this code. Please report unacceptable behavior to [igv-team@broadinstitute.org](mailto:igv-team@broadinstitute.org).

## **Did you find a bug?**

* **Ensure the bug was not already reported** by searching on GitHub under [Issues](https://github.com/igvteam/igv/issues).

* If you're unable to find an open issue addressing the problem, [open a new one](https://github.com/igvteam/igv/issues/new). Be sure to include a **title and clear description**, as much relevant information as possible, and a **code sample, executable test case, or clear set of instructions** demonstrating the expected behavior that is not occurring.

## **Did you write a patch that fixes a bug?**

* Open a new GitHub pull request with the patch.

* Ensure the Pull Request description clearly describes the problem and solution. Include the relevant issue number if applicable.  Keep the pull request as focused as possible.  Try not to fix multiple unrelated issues with a single pull requess.

## **Did you fix whitespace, format code, or make a purely cosmetic patch?**

Changes that are cosmetic in nature and do not add anything to the stability, functionality, or testability of IGV are still welcome.

## **Do you intend to add a new feature or change an existing one?**

* Suggest your change by creating a Github issue to open a discussion.

IGV is a group effort. We encourage you to pitch in and join the team.

Thanks!

The IGV team,
UC San Diego and Broad Institute
