---
title: 'Upgrading to DefectDojo Version 2.30.x'
toc_hide: true
weight: -20231211
description: Breaking Change for Auditlog.
---
There are instructions for upgrading to 2.30.0 if you disabled `enable_auditlog` before (read below). Check the [Release Notes](https://github.com/DefectDojo/django-DefectDojo/releases/tag/2.30.0) for the contents of the release.

**Breaking Change**

Parameter `enable_auditlog` is not possible to set through System settings anymore. If you set this parameter or you need to change it to `False` (to disable audit logging), set environmental variable `DD_ENABLE_AUDITLOG` to `False`.

If you are using docker-compose, another EnvVar should be added to the `docker-compose.yml` file in all the containers ran by the django image. This should do the trick
```yaml
DD_ENABLE_AUDITLOG: ${DD_ENABLE_AUDITLOG:-False}
```
Somewhere in the `environment` blocks for the `uwsgi`, `celerybeat`, `celeryworker`, and `init` containers.